/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blockentitites;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.packagePort.frogport.FrogportBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import fr.iglee42.createqualityoflife.behaviours.EnderPackagerBehaviour;
import fr.iglee42.createqualityoflife.blocks.EnderPackagerBlock;
import fr.iglee42.createqualityoflife.utils.EnderPackagerFrequencySlot;
import fr.iglee42.createqualityoflife.utils.EnderPackagerItemHandler;
import java.util.List;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class EnderPackagerBlockEntity
extends SmartBlockEntity {
    private boolean receivedSignalChanged;
    private int receivedSignal;
    private int transmittedSignal;
    private EnderPackagerBehaviour link;
    private boolean transmitter;
    public ItemStack heldBox = ItemStack.f_41583_;
    public final EnderPackagerItemHandler inventory = new EnderPackagerItemHandler(this);
    private final LazyOptional<IItemHandler> invProvider = LazyOptional.of(() -> this.inventory);
    public static final int CYCLE = 20;
    public int animationTicks = 0;
    public boolean animationInward = true;
    public String addressFilter = "";

    public EnderPackagerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.invProvider.cast();
        }
        return super.getCapability(cap, side);
    }

    public void addBehavioursDeferred(List<BlockEntityBehaviour> behaviours) {
        this.createLink();
        behaviours.add(this.link);
    }

    protected void createLink() {
        Pair slots = ValueBoxTransform.Dual.makeSlots(EnderPackagerFrequencySlot::new);
        this.link = this.transmitter ? EnderPackagerBehaviour.transmitter(this, (Pair<ValueBoxTransform, ValueBoxTransform>)slots) : EnderPackagerBehaviour.receiver(this, (Pair<ValueBoxTransform, ValueBoxTransform>)slots, () -> this.inventory);
    }

    public void invalidate() {
        super.invalidate();
        this.invProvider.invalidate();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128379_("Transmitter", this.transmitter);
        compound.m_128405_("Receive", this.getReceivedSignal());
        compound.m_128379_("ReceivedChanged", this.receivedSignalChanged);
        compound.m_128405_("Transmit", this.transmittedSignal);
        super.write(compound, clientPacket);
        compound.m_128379_("AnimationInward", this.animationInward);
        compound.m_128405_("AnimationTicks", this.animationTicks);
        compound.m_128365_("HeldBox", (Tag)this.heldBox.m_41739_(new CompoundTag()));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        this.transmitter = compound.m_128471_("Transmitter");
        super.read(compound, clientPacket);
        this.animationInward = compound.m_128471_("AnimationInward");
        this.animationTicks = compound.m_128451_("AnimationTicks");
        this.heldBox = ItemStack.m_41712_((CompoundTag)compound.m_128469_("HeldBox"));
        this.receivedSignal = compound.m_128451_("Receive");
        this.receivedSignalChanged = compound.m_128471_("ReceivedChanged");
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || !this.link.newPosition) {
            this.transmittedSignal = compound.m_128451_("Transmit");
        }
    }

    public void tick() {
        super.tick();
        if (this.isTransmitterBlock() != this.transmitter) {
            this.transmitter = this.isTransmitterBlock();
            EnderPackagerBehaviour prevlink = this.link;
            this.removeBehaviour(EnderPackagerBehaviour.TYPE);
            this.createLink();
            this.link.copyItemsFrom(prevlink);
            this.attachBehaviourLate(this.link);
        }
        if (this.animationTicks == 0) {
            return;
        }
        if (this.f_58857_.f_46443_) {
            if (this.animationTicks == 20 - (this.animationInward ? 5 : 1)) {
                AllSoundEvents.PACKAGER.playAt(this.f_58857_, (Vec3i)this.f_58858_, 1.0f, 1.0f, true);
            }
            if (this.animationTicks == (this.animationInward ? 1 : 5)) {
                this.f_58857_.m_245747_(this.f_58858_, SoundEvents.f_12011_, SoundSource.BLOCKS, 0.25f, 0.75f, true);
            }
        }
        --this.animationTicks;
        if (this.animationTicks == 0 && !this.f_58857_.m_5776_()) {
            if (!this.isTransmitter()) {
                this.wakeTheFrogs();
            } else {
                this.sendPackage();
            }
            this.m_6596_();
        }
    }

    private void sendPackage() {
        if (this.heldBox.m_41619_()) {
            return;
        }
        ((EnderPackagerBehaviour)this.getBehaviour(EnderPackagerBehaviour.TYPE)).sendPackage(this.heldBox);
        this.inventory.extractItem(0, 64, false);
    }

    protected void wakeTheFrogs() {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(Direction.UP));
        if (blockEntity instanceof FrogportBlockEntity) {
            FrogportBlockEntity port = (FrogportBlockEntity)blockEntity;
            port.tryPullingFromOwnAndAdjacentInventories();
        }
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.transmitter) {
            this.updateSignAddress();
            return;
        }
        this.attemptToSend();
    }

    public void attemptToSend() {
        if (this.heldBox.m_41619_() || this.animationTicks != 0) {
            return;
        }
        if (!((EnderPackagerBehaviour)this.getBehaviour(EnderPackagerBehaviour.TYPE)).canSendPackage(this.heldBox)) {
            return;
        }
        this.animationInward = true;
        this.animationTicks = 20;
        this.notifyUpdate();
    }

    public void remove() {
        super.remove();
    }

    public float getTrayOffset(float partialTicks) {
        float tickCycle = this.animationInward ? (float)this.animationTicks - partialTicks : (float)(this.animationTicks - 5) - partialTicks;
        float progress = Mth.m_14036_((float)(tickCycle / 15.0f * 2.0f - 1.0f), (float)-1.0f, (float)1.0f);
        progress = 1.0f - progress * progress;
        return progress * progress;
    }

    public ItemStack getRenderedBox() {
        if (this.animationTicks == 0) {
            return this.heldBox;
        }
        if (this.animationInward) {
            return this.animationTicks <= 10 ? ItemStack.f_41583_ : this.heldBox;
        }
        return this.animationTicks >= 10 ? ItemStack.f_41583_ : this.heldBox;
    }

    protected Boolean isTransmitterBlock() {
        return (Boolean)this.m_58900_().m_61143_((Property)EnderPackagerBlock.POWERED) == false;
    }

    public boolean isTransmitter() {
        return this.transmitter;
    }

    public int getReceivedSignal() {
        return this.receivedSignal;
    }

    public boolean doesMatchAddress(ItemStack stack) {
        return this.addressFilter.isBlank() || PackageItem.matchAddress((ItemStack)stack, (String)this.addressFilter);
    }

    public void receivedBox() {
        if (this.heldBox.m_41619_() || this.animationTicks != 0) {
            return;
        }
        this.animationInward = false;
        this.animationTicks = 20;
        this.notifyUpdate();
    }

    protected void updateSignAddress() {
        this.addressFilter = "";
        for (Direction side : Iterate.directions) {
            String address = this.getSign(side);
            if (address == null || address.isBlank()) continue;
            this.addressFilter = address;
        }
    }

    protected String getSign(Direction side) {
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(side));
        if (!(blockEntity instanceof SignBlockEntity)) {
            return null;
        }
        SignBlockEntity sign = (SignBlockEntity)blockEntity;
        for (boolean front : Iterate.trueAndFalse) {
            SignText text = sign.m_277157_(front);
            Object address = "";
            for (Component component : text.m_276945_(false)) {
                String string = component.getString();
                if (string.isBlank()) continue;
                address = (String)address + string.trim() + " ";
            }
            if (((String)address).isBlank()) continue;
            return ((String)address).trim();
        }
        return null;
    }
}

