/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.blockentitites;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.logistics.tunnel.BrassTunnelModeSlot;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.utility.CreateLang;
import fr.iglee42.createqualityoflife.registries.QOLIcons;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.PlayerArmorInvWrapper;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.items.wrapper.PlayerOffhandInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryLinkerBlockEntity
extends KineticBlockEntity {
    private ItemStack playerPaperItemStack = ItemStack.f_41583_;
    private IItemHandler linkedInventoryContent = new ItemStackHandler(0);
    private LazyOptional<?> inventoryOptional = LazyOptional.empty();
    private UUID linkedPlayer;
    protected ScrollOptionBehaviour<Mode> selectionMode;

    public InventoryLinkerBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.selectionMode = new ScrollOptionBehaviour(Mode.class, (Component)CreateLang.translateDirect((String)"options.inventory_linker.label", (Object[])new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new BrassTunnelModeSlot());
        behaviours.add((BlockEntityBehaviour)this.selectionMode);
    }

    public UUID getLinkedPlayer() {
        return this.linkedPlayer;
    }

    public void tick() {
        super.tick();
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (!this.isSpeedRequirementFulfilled()) {
            return;
        }
        this.linkedPlayer = !this.playerPaperItemStack.m_41619_() && this.playerPaperItemStack.m_41784_().m_128441_("linkedPlayer") ? this.playerPaperItemStack.m_41784_().m_128342_("linkedPlayer") : null;
        if (this.linkedPlayer != null && this.f_58857_.m_46003_(this.linkedPlayer) != null) {
            this.linkedInventoryContent = switch ((Mode)this.selectionMode.get()) {
                default -> throw new IncompatibleClassChangeError();
                case Mode.INVENTORY -> new PlayerMainInvWrapper(this.f_58857_.m_46003_(this.linkedPlayer).m_150109_());
                case Mode.ARMOR -> new PlayerArmorInvWrapper(this.f_58857_.m_46003_(this.linkedPlayer).m_150109_());
                case Mode.OFF_HAND -> new PlayerOffhandInvWrapper(this.f_58857_.m_46003_(this.linkedPlayer).m_150109_());
            };
        }
        this.inventoryOptional = LazyOptional.of(() -> this.linkedInventoryContent);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return cap == ForgeCapabilities.ITEM_HANDLER ? (side != Direction.DOWN ? this.inventoryOptional.cast() : super.getCapability(cap, side)) : super.getCapability(cap, side);
    }

    public void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128405_("mode", this.selectionMode.getValue());
        tag.m_128365_("paper", (Tag)this.playerPaperItemStack.serializeNBT());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.selectionMode.setValue(compound.m_128451_("mode"));
        this.playerPaperItemStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("paper"));
    }

    public void setPlayerPaperItemStack(ItemStack playerPaperItemStack) {
        this.playerPaperItemStack = playerPaperItemStack;
    }

    public ItemStack getPlayerPaperItemStack() {
        return this.playerPaperItemStack;
    }

    public void remove() {
        super.remove();
        this.linkedInventoryContent = new ItemStackHandler(0);
        Block.m_49840_((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)this.playerPaperItemStack);
    }

    public static enum Mode implements INamedIconOptions
    {
        INVENTORY(0, 36, QOLIcons.I_INVENTORY),
        ARMOR(1, 4, QOLIcons.I_ARMOR),
        OFF_HAND(2, 1, QOLIcons.I_OFF_HAND);

        private int id;
        private int slotCount;
        private AllIcons icon;

        private Mode(int id, int slotCount, AllIcons icon) {
            this.id = id;
            this.slotCount = slotCount;
            this.icon = icon;
        }

        public int getSlotCount() {
            return this.slotCount;
        }

        public int getId() {
            return this.id;
        }

        public static Mode getById(int id) {
            return Arrays.stream(Mode.values()).filter(m -> m.getId() == id).findFirst().orElse(INVENTORY);
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return "options.inventory_linker." + this.name().toLowerCase();
        }
    }
}

