/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.tabs;

import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.gui.widget.IconButton;
import com.simibubi.create.foundation.utility.CreateLang;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.client.screens.ConfigureStatueScreen;
import fr.iglee42.createqualityoflife.client.screens.tabs.StatueTab;
import fr.iglee42.createqualityoflife.client.screens.widgets.NotUpdatableEditBox;
import fr.iglee42.createqualityoflife.client.screens.widgets.ScrollableEditBox;
import fr.iglee42.createqualityoflife.packets.PublishAnimationPacket;
import fr.iglee42.createqualityoflife.registries.QOLGuiTextures;
import fr.iglee42.createqualityoflife.registries.QOLIcons;
import fr.iglee42.createqualityoflife.registries.QOLPackets;
import fr.iglee42.createqualityoflife.statue.animation.StatueAnimation;
import fr.iglee42.createqualityoflife.statue.animation.StatueAnimationFrame;
import fr.iglee42.createqualityoflife.statue.animation.StatuePartTable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.createmod.catnip.gui.element.ScreenElement;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.Rotations;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.Items;

public class AnimationTab
extends StatueTab {
    public static final int LOOP_X = 0;
    public static final int REVERT_X = 22;
    public static final int COPY_ALL_X = 44;
    private static final List<Component> LOOP_TOOLTIPS = List.of(CreateLang.translateDirect((String)"schedule.loop", (Object[])new Object[0]), CreateLang.translateDirect((String)"gui.schematicannon.optionDisabled", (Object[])new Object[0]).m_130940_(ChatFormatting.RED));
    private static final List<Component> ON_LOOP_TOOLTIPS = List.of(CreateLang.translateDirect((String)"schedule.loop", (Object[])new Object[0]), CreateLang.translateDirect((String)"gui.schematicannon.optionEnabled", (Object[])new Object[0]).m_130940_(ChatFormatting.GREEN));
    private static final List<Component> REVERSE_TOOLTIPS = List.of(CreateQOLLang.translateDirect("statue.animation.revert", new Object[0]), CreateLang.translateDirect((String)"gui.schematicannon.optionDisabled", (Object[])new Object[0]).m_130940_(ChatFormatting.RED), CreateQOLLang.translateDirect("statue.animation.revert_1", new Object[0]), CreateQOLLang.translateDirect("statue.animation.revert_2", new Object[0]));
    private static final List<Component> ON_REVERSE_TOOLTIPS = List.of(CreateQOLLang.translateDirect("statue.animation.revert", new Object[0]), CreateLang.translateDirect((String)"gui.schematicannon.optionEnabled", (Object[])new Object[0]).m_130940_(ChatFormatting.GREEN), CreateQOLLang.translateDirect("statue.animation.revert_1", new Object[0]), CreateQOLLang.translateDirect("statue.animation.revert_2", new Object[0]));
    private static final List<Component> COPY_ALL_TOOLTIPS = List.of(CreateQOLLang.translateDirect("statue.animation.copy_all", new Object[0]), CreateQOLLang.translateDirect("statue.animation.copy_all_1", new Object[0]), CreateQOLLang.translateDirect("statue.animation.copy_all_2", new Object[0]));
    private StatueAnimation animation;
    private IconButton loopButton;
    private IconButton revertButton;
    private IconButton createButton;
    private IconButton copyAllButton;
    private NotUpdatableEditBox frameSelector;
    private IconButton previousFrameButton;
    private IconButton nextFrameButton;
    private IconButton deleteFrameButton;
    private IconButton publishButton;
    private EditBox nameEdit;
    List<ScrollableEditBox> editWidgets;
    List<IconButton> iconButtons;
    private int currentFrame;

    public AnimationTab(int index, ConfigureStatueScreen parent) {
        super(index, Items.f_42686_, parent, "statue.animationTab");
        this.animation = parent.getExampleStatue().getAnimation().orElse(null);
    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial, int x, int y) {
        y -= 14;
        this.createButton.f_93624_ = this.animation == null || this.getCurrentFrame() == null;
        this.loopButton.f_93624_ = this.animation != null;
        this.revertButton.f_93624_ = this.animation != null;
        this.editWidgets.forEach(b -> {
            b.f_93624_ = this.animation != null && this.getCurrentFrame() != null;
        });
        this.iconButtons.forEach(b -> {
            b.f_93624_ = this.animation != null && this.getCurrentFrame() != null;
        });
        this.copyAllButton.f_93624_ = this.animation != null && this.getCurrentFrame() != null;
        this.deleteFrameButton.f_93624_ = this.animation != null && this.getCurrentFrame() != null;
        this.frameSelector.f_93624_ = this.animation != null;
        this.previousFrameButton.f_93624_ = this.animation != null;
        this.previousFrameButton.f_93623_ = this.previousFrameButton.f_93624_ && this.getCurrentFrame() != null && this.animation.getPreviousFrame(this.getCurrentFrame()) != null;
        this.nextFrameButton.f_93624_ = this.animation != null;
        this.nextFrameButton.f_93623_ = this.nextFrameButton.f_93624_ && this.getCurrentFrame() != null && this.animation.getNextFrame(this.getCurrentFrame()) != null;
        this.publishButton.f_93624_ = this.animation != null;
        boolean bl = this.nameEdit.f_93624_ = this.animation != null;
        if (this.animation != null) {
            this.loopButton.getToolTip().clear();
            this.revertButton.getToolTip().clear();
            this.loopButton.getToolTip().addAll(this.loopButton.green ? ON_LOOP_TOOLTIPS : LOOP_TOOLTIPS);
            this.revertButton.getToolTip().addAll(this.revertButton.green ? ON_REVERSE_TOOLTIPS : REVERSE_TOOLTIPS);
            this.animation.setLoop(this.loopButton.green);
            this.animation.setRevert(this.revertButton.green);
        }
        if (this.animation != null && this.getCurrentFrame() != null) {
            QOLGuiTextures.ROTATIONS.render(graphics, x + 20 + 4, y + 4 + 20);
            QOLGuiTextures.ROTATIONS.render(graphics, x + 20 + 4, y + 6 + 40);
            QOLGuiTextures.ROTATIONS.render(graphics, x + 20 + 4, y + 8 + 60);
            QOLGuiTextures.ROTATIONS.render(graphics, x + 20 + 4, y + 10 + 80);
            QOLGuiTextures.ROTATIONS.render(graphics, x + 20 + 4, y + 12 + 100);
            QOLGuiTextures.ROTATIONS.render(graphics, x + 20 + 4, y + 14 + 120);
        }
        if (this.animation != null) {
            QOLGuiTextures.NAME_EDIT_BOX.render(graphics, x + 2 + 0 + 19, y + 173 - 19);
            QOLGuiTextures.SIMPLE_EDIT_BOX.render(graphics, this.getParent().getGuiLeft() + this.getParent().f_97726_ / 2 - 25 + Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)CreateQOLLang.translateDirect("statue.animation.frame", new Object[0])), this.getParent().getGuiTop() + this.getParent().f_97727_ - 24);
            graphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)CreateQOLLang.translateDirect("statue.animation.frame", new Object[0]), this.getParent().getGuiLeft() + this.getParent().f_97726_ / 2 - 25, this.getParent().getGuiTop() + this.getParent().f_97727_ - 24 + 5 - 1, 0xFFFFFF);
        }
        if (this.animation != null && this.getCurrentFrame() == null) {
            graphics.m_280554_(Minecraft.m_91087_().f_91062_, (FormattedText)CreateQOLLang.translateDirect("statue.animation.frame.create", new Object[0]), x + 6, y + 86 - 64, 119, 0xFFFFFF);
        } else if (this.animation == null) {
            graphics.m_280554_(Minecraft.m_91087_().f_91062_, (FormattedText)CreateQOLLang.translateDirect("statue.animation.create", new Object[0]), x + 6, y + 86 - 64, 119, 0xFFFFFF);
        }
    }

    @Override
    public void forEachWidgets(Consumer<AbstractWidget> function) {
        function.accept((AbstractWidget)this.createButton);
        function.accept((AbstractWidget)this.loopButton);
        function.accept((AbstractWidget)this.revertButton);
        function.accept((AbstractWidget)this.copyAllButton);
        function.accept((AbstractWidget)this.frameSelector);
        function.accept((AbstractWidget)this.previousFrameButton);
        function.accept((AbstractWidget)this.nextFrameButton);
        function.accept((AbstractWidget)this.deleteFrameButton);
        function.accept((AbstractWidget)this.publishButton);
        function.accept((AbstractWidget)this.nameEdit);
        this.editWidgets.forEach(function);
        this.iconButtons.forEach(function);
    }

    @Override
    public void initWidgets(int x, int y) {
        this.createButton = new IconButton(x + 61, (y -= 14) + 77, (ScreenElement)AllIcons.I_ADD);
        this.createButton.withCallback(this::createButtonCallback);
        this.loopButton = new IconButton(x + 2 + 0, y + 2, (ScreenElement)AllIcons.I_REFRESH);
        this.loopButton.withCallback(() -> {
            this.loopButton.green = !this.loopButton.green;
        });
        this.revertButton = new IconButton(x + 2 + 22, y + 2, (ScreenElement)AllIcons.I_CONFIG_BACK);
        this.revertButton.withCallback(() -> {
            this.revertButton.green = !this.revertButton.green;
        });
        this.copyAllButton = new IconButton(x + 2 + 44, y + 2, (ScreenElement)AllIcons.I_TARGET);
        this.copyAllButton.withCallback(() -> {
            this.updateRotation(f -> f.withGlobalRotation(this.getExampleStatue().getEntityXRotation(), this.getExampleStatue().m_146908_(), this.getExampleStatue().getEntityZRotation()).withHeadRotation(this.getExampleStatue().getHeadPose().m_123156_(), this.getExampleStatue().getHeadPose().m_123157_(), this.getExampleStatue().getHeadPose().m_123158_()).withLeftArmRotation(this.getExampleStatue().getLeftArmPose().m_123156_(), this.getExampleStatue().getLeftArmPose().m_123157_(), this.getExampleStatue().getLeftArmPose().m_123158_()).withRightArmRotation(this.getExampleStatue().getRightArmPose().m_123156_(), this.getExampleStatue().getRightArmPose().m_123157_(), this.getExampleStatue().getRightArmPose().m_123158_()).withLeftLegRotation(this.getExampleStatue().getLeftLegPose().m_123156_(), this.getExampleStatue().getLeftLegPose().m_123157_(), this.getExampleStatue().getLeftLegPose().m_123158_()).withRightLegRotation(this.getExampleStatue().getRightLegPose().m_123156_(), this.getExampleStatue().getRightLegPose().m_123157_(), this.getExampleStatue().getRightLegPose().m_123158_()));
            this.updateBoxesFromFrame(this.currentFrame);
        });
        this.copyAllButton.getToolTip().addAll(COPY_ALL_TOOLTIPS);
        this.deleteFrameButton = new IconButton(x + 2 + 44 + 22, y + 2, (ScreenElement)AllIcons.I_CONFIG_DISCARD);
        this.deleteFrameButton.withCallback(() -> this.animation.deleteFrame(this.getCurrentFrame()));
        this.deleteFrameButton.setToolTip((Component)CreateQOLLang.translateDirect("statue.animation.delete_frame", new Object[0]));
        this.frameSelector = new NotUpdatableEditBox(Minecraft.m_91087_().f_91062_, this.getParent().getGuiLeft() + this.getParent().f_97726_ / 2 - 23 + Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)CreateQOLLang.translateDirect("statue.animation.frame", new Object[0])), this.getParent().getGuiTop() + this.getParent().f_97727_ - 24 + 5, 32, 18, CommonComponents.f_237098_);
        this.frameSelector.m_94182_(false);
        this.frameSelector.m_94144_("" + this.currentFrame);
        this.frameSelector.m_94199_(4);
        this.frameSelector.m_94202_(0xFFFFFF);
        this.frameSelector.m_93692_(false);
        this.frameSelector.m_6375_(0.0, 0.0, 0);
        this.frameSelector.m_94151_(s -> {
            if (!s.isEmpty()) {
                try {
                    this.changeFrame(Integer.parseInt(s), true);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.frameSelector.m_94153_(s -> {
            if (s.isEmpty()) {
                return true;
            }
            try {
                int i = Integer.parseInt(s);
                return i >= 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        this.previousFrameButton = new IconButton(this.getParent().getGuiLeft() + this.getParent().f_97726_ / 2 - 23 - 22, this.getParent().getGuiTop() + this.getParent().f_97727_ - 24, (ScreenElement)AllIcons.I_CONFIG_BACK);
        this.previousFrameButton.withCallback(() -> {
            if (this.animation != null && this.animation.getPreviousFrame(this.getCurrentFrame()) != null) {
                this.changeFrame(this.animation.getPreviousFrame(this.getCurrentFrame()).getTick(), false);
            }
        });
        this.previousFrameButton.setToolTip((Component)CreateQOLLang.translateDirect("statue.animation.previous_frame", new Object[0]));
        this.nextFrameButton = new IconButton(this.getParent().getGuiLeft() + this.getParent().f_97726_ / 2 - 23 + Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)CreateQOLLang.translateDirect("statue.animation.frame", new Object[0])) + 26, this.getParent().getGuiTop() + this.getParent().f_97727_ - 24, (ScreenElement)AllIcons.I_CONFIG_OPEN);
        this.nextFrameButton.withCallback(() -> {
            if (this.animation != null && this.animation.getNextFrame(this.getCurrentFrame()) != null) {
                this.changeFrame(this.animation.getNextFrame(this.getCurrentFrame()).getTick(), false);
            }
        });
        this.nextFrameButton.setToolTip((Component)CreateQOLLang.translateDirect("statue.animation.next_frame", new Object[0]));
        this.publishButton = new IconButton(x + 2 + 0, y + 173 - 19, (ScreenElement)AllIcons.I_SEND_ONLY);
        this.publishButton.withCallback(() -> {
            if (!this.nameEdit.m_94155_().isEmpty()) {
                QOLPackets.getChannel().sendToServer((Object)new PublishAnimationPacket(Minecraft.m_91087_().f_91074_.m_20148_(), this.nameEdit.m_94155_(), this.animation));
            }
        });
        this.publishButton.setToolTip((Component)CreateQOLLang.translateDirect("statue.animation.publish", new Object[0]));
        this.nameEdit = new EditBox(Minecraft.m_91087_().f_91062_, x + 2 + 0 + 21, y + 173 - 19 + 5, 99, 18, CommonComponents.f_237098_);
        this.nameEdit.m_94182_(false);
        this.nameEdit.m_93692_(false);
        this.nameEdit.m_257771_((Component)CreateQOLLang.translateDirect("statue.animation.publishName", new Object[0]));
        this.nameEdit.m_257544_(Tooltip.m_257550_((Component)CreateQOLLang.translateDirect("statue.name_utility", new Object[0])));
        if (this.animation != null) {
            this.loopButton.green = this.animation.isLooping();
            this.revertButton.green = this.animation.canBeRevert();
        }
        int offsetY = 22;
        this.editWidgets = new ArrayList<ScrollableEditBox>();
        this.iconButtons = new ArrayList<IconButton>();
        this.setupRotationControls(x, y + offsetY, QOLIcons.I_STATUE, () -> this.getCurrentFrame().getGlobal(), () -> this.getExampleStatue().getEntityRotations(), this::updateGlobal, rot -> frame -> frame.withGlobalRotation(rot.m_123156_(), rot.m_123157_(), rot.m_123158_()), PlayerModelPart.CAPE, this.editWidgets, this.iconButtons);
        this.setupRotationControls(x, y + (offsetY += 22), QOLIcons.I_HAT, () -> this.getCurrentFrame().getHead(), () -> this.getExampleStatue().getHeadPose(), this::updateHead, rot -> frame -> frame.withHeadRotation(rot.m_123156_(), rot.m_123157_(), rot.m_123158_()), PlayerModelPart.HAT, this.editWidgets, this.iconButtons);
        this.setupRotationControls(x, y + (offsetY += 22), QOLIcons.I_LEFT_SLEEVE, () -> this.getCurrentFrame().getLeftArm(), () -> this.getExampleStatue().getLeftArmPose(), this::updateLeftArm, rot -> frame -> frame.withLeftArmRotation(rot.m_123156_(), rot.m_123157_(), rot.m_123158_()), PlayerModelPart.LEFT_SLEEVE, this.editWidgets, this.iconButtons);
        this.setupRotationControls(x, y + (offsetY += 22), QOLIcons.I_RIGHT_SLEEVE, () -> this.getCurrentFrame().getRightArm(), () -> this.getExampleStatue().getRightArmPose(), this::updateRightArm, rot -> frame -> frame.withRightArmRotation(rot.m_123156_(), rot.m_123157_(), rot.m_123158_()), PlayerModelPart.RIGHT_SLEEVE, this.editWidgets, this.iconButtons);
        this.setupRotationControls(x, y + (offsetY += 22), QOLIcons.I_LEFT_PANTS, () -> this.getCurrentFrame().getLeftLeg(), () -> this.getExampleStatue().getLeftLegPose(), this::updateLeftLeg, rot -> frame -> frame.withLeftLegRotation(rot.m_123156_(), rot.m_123157_(), rot.m_123158_()), PlayerModelPart.LEFT_PANTS_LEG, this.editWidgets, this.iconButtons);
        this.setupRotationControls(x, y + (offsetY += 22), QOLIcons.I_RIGHT_PANTS, () -> this.getCurrentFrame().getRightLeg(), () -> this.getExampleStatue().getRightLegPose(), this::updateRightLeg, rot -> frame -> frame.withRightLegRotation(rot.m_123156_(), rot.m_123157_(), rot.m_123158_()), PlayerModelPart.RIGHT_PANTS_LEG, this.editWidgets, this.iconButtons);
    }

    private void setupRotationControls(int x, int yOffset, QOLIcons icon, Supplier<StatuePartTable> currentFrameSupplier, Supplier<Rotations> defaultPoseSupplier, BiConsumer<Character, Integer> updater, Function<Rotations, Function<StatueAnimationFrame, StatueAnimationFrame>> rotationSetter, PlayerModelPart tooltipPart, List<ScrollableEditBox> collector, List<IconButton> buttons) {
        ScrollableEditBox boxX = new ScrollableEditBox(Minecraft.m_91087_().f_91062_, x + 20 + 2 + 4, yOffset + 5 + 2, 32, 18, CommonComponents.f_237098_);
        ScrollableEditBox boxY = new ScrollableEditBox(Minecraft.m_91087_().f_91062_, x + 20 + 2 + 4 + 30, yOffset + 5 + 2, 32, 18, CommonComponents.f_237098_);
        ScrollableEditBox boxZ = new ScrollableEditBox(Minecraft.m_91087_().f_91062_, x + 20 + 2 + 4 + 60, yOffset + 5 + 2, 32, 18, CommonComponents.f_237098_);
        boxX.setPrefix((Component)Component.m_237113_((String)"X: "));
        boxY.setPrefix((Component)Component.m_237113_((String)"Y: "));
        boxZ.setPrefix((Component)Component.m_237113_((String)"Z: "));
        this.setupEditBoxes((value, widget) -> {
            char axis = widget == boxX ? (char)'x' : (widget == boxY ? (char)'y' : (char)'z');
            updater.accept(Character.valueOf(axis), (Integer)value);
        }, boxX, boxY, boxZ);
        if (this.animation != null && this.getCurrentFrame() != null) {
            StatuePartTable part = currentFrameSupplier.get();
            this.updateEditBoxes((int)part.getXRot(), (int)part.getYRot(), (int)part.getZRot(), boxX, boxY, boxZ);
        }
        IconButton button = new IconButton(x + 2, yOffset + 2, (ScreenElement)icon);
        button.withCallback(() -> {
            Rotations rot = (Rotations)defaultPoseSupplier.get();
            this.updateRotation((Function)rotationSetter.apply(rot));
            boxX.m_94144_("" + (int)rot.m_123156_());
            boxY.m_94144_("" + (int)rot.m_123157_());
            boxZ.m_94144_("" + (int)rot.m_123158_());
        });
        button.getToolTip().addAll(this.createTooltipFor(tooltipPart));
        buttons.add(button);
        collector.add(boxX);
        collector.add(boxY);
        collector.add(boxZ);
    }

    private void changeFrame(int newFrame, boolean fromSelector) {
        this.currentFrame = newFrame;
        if (!fromSelector) {
            this.frameSelector.setValueNoUpdate("" + newFrame);
        }
        this.updateBoxesFromFrame(newFrame);
    }

    private void updateBoxesFromFrame(int currentFrame) {
        StatueAnimationFrame frame = this.animation.getPreciseFrame(currentFrame);
        if (frame != null) {
            List<StatuePartTable> rotations = List.of(frame.getGlobal(), frame.getHead(), frame.getLeftArm(), frame.getRightArm(), frame.getLeftLeg(), frame.getRightLeg());
            int widgetIndex = 0;
            for (StatuePartTable rot : rotations) {
                this.editWidgets.get(widgetIndex++).m_94144_("" + (int)rot.getXRot());
                this.editWidgets.get(widgetIndex++).m_94144_("" + (int)rot.getYRot());
                this.editWidgets.get(widgetIndex++).m_94144_("" + (int)rot.getZRot());
            }
        }
    }

    private List<Component> createTooltipFor(PlayerModelPart part) {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add((Component)CreateQOLLang.translateDirect("statue.animation.copy_from", CreateQOLLang.translateDirect("statue.rotation." + part.name().toLowerCase(), new Object[0])));
        return components;
    }

    private void setupEditBoxes(BiConsumer<Integer, ScrollableEditBox> onChanged, ScrollableEditBox ... inputs) {
        for (ScrollableEditBox widget : inputs) {
            widget.m_94199_(4);
            widget.m_94182_(false);
            widget.m_94202_(0xFFFFFF);
            widget.m_93692_(false);
            widget.m_6375_(0.0, 0.0, 0);
            widget.m_94151_(s -> {
                if (!s.isEmpty()) {
                    try {
                        int i = Integer.parseInt(s);
                        onChanged.accept(i, widget);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            });
            widget.m_94153_(s -> {
                if (s.isEmpty() || s.equals("-")) {
                    return true;
                }
                try {
                    int i = Integer.parseInt(s);
                    return i >= -180 && i < 180;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
        }
    }

    private void updateEditBoxes(int value1, int value2, int value3, EditBox ... inputs) {
        if (inputs.length != 3) {
            return;
        }
        inputs[0].m_94144_("" + value1);
        inputs[1].m_94144_("" + value2);
        inputs[2].m_94144_("" + value3);
    }

    @Override
    public void onQuit() {
        super.onQuit();
        this.getExampleStatue().setAnimation(this.animation);
    }

    private StatueAnimationFrame getCurrentFrame() {
        if (this.animation == null) {
            return null;
        }
        return this.animation.getPreciseFrame(this.currentFrame);
    }

    private void updateRotation(Function<StatueAnimationFrame, StatueAnimationFrame> function) {
        if (this.animation == null) {
            return;
        }
        if (!this.animation.doesFrameExist(this.currentFrame)) {
            return;
        }
        StatueAnimationFrame frame = this.getCurrentFrame();
        frame = function.apply(frame);
        this.animation.updateFrame(this.currentFrame, frame);
    }

    private void updateGlobal(char axis, int value) {
        this.updateRotation(f -> {
            StatuePartTable current = f.getGlobal();
            float x = current.getXRot();
            float y = current.getYRot();
            float z = current.getZRot();
            switch (axis) {
                case 'x': {
                    x = value;
                    break;
                }
                case 'y': {
                    y = value;
                    break;
                }
                case 'z': {
                    z = value;
                }
            }
            return f.withGlobalRotation(x, y, z);
        });
    }

    private void updateHead(char axis, int value) {
        this.updateRotation(f -> {
            StatuePartTable current = f.getHead();
            float x = current.getXRot();
            float y = current.getYRot();
            float z = current.getZRot();
            switch (axis) {
                case 'x': {
                    x = value;
                    break;
                }
                case 'y': {
                    y = value;
                    break;
                }
                case 'z': {
                    z = value;
                }
            }
            return f.withHeadRotation(x, y, z);
        });
    }

    private void updateLeftArm(char axis, int value) {
        this.updateRotation(f -> {
            StatuePartTable current = f.getLeftArm();
            float x = current.getXRot();
            float y = current.getYRot();
            float z = current.getZRot();
            switch (axis) {
                case 'x': {
                    x = value;
                    break;
                }
                case 'y': {
                    y = value;
                    break;
                }
                case 'z': {
                    z = value;
                }
            }
            return f.withLeftArmRotation(x, y, z);
        });
    }

    private void updateRightArm(char axis, int value) {
        this.updateRotation(f -> {
            StatuePartTable current = f.getRightArm();
            float x = current.getXRot();
            float y = current.getYRot();
            float z = current.getZRot();
            switch (axis) {
                case 'x': {
                    x = value;
                    break;
                }
                case 'y': {
                    y = value;
                    break;
                }
                case 'z': {
                    z = value;
                }
            }
            return f.withRightArmRotation(x, y, z);
        });
    }

    private void updateLeftLeg(char axis, int value) {
        this.updateRotation(f -> {
            StatuePartTable current = f.getLeftLeg();
            float x = current.getXRot();
            float y = current.getYRot();
            float z = current.getZRot();
            switch (axis) {
                case 'x': {
                    x = value;
                    break;
                }
                case 'y': {
                    y = value;
                    break;
                }
                case 'z': {
                    z = value;
                }
            }
            return f.withLeftLegRotation(x, y, z);
        });
    }

    private void updateRightLeg(char axis, int value) {
        this.updateRotation(f -> {
            StatuePartTable current = f.getRightLeg();
            float x = current.getXRot();
            float y = current.getYRot();
            float z = current.getZRot();
            switch (axis) {
                case 'x': {
                    x = value;
                    break;
                }
                case 'y': {
                    y = value;
                    break;
                }
                case 'z': {
                    z = value;
                }
            }
            return f.withRightLegRotation(x, y, z);
        });
    }

    private void createButtonCallback() {
        if (this.animation == null) {
            this.animation = new StatueAnimation();
        } else if (this.getCurrentFrame() == null) {
            this.animation.addFrame(new StatueAnimationFrame(this.currentFrame));
        } else {
            throw new RuntimeException(new IllegalAccessException("Create Button shouldn't be accessible when animation and frame aren't null, animation: " + String.valueOf(this.animation) + ", frame: " + String.valueOf(this.getCurrentFrame())));
        }
    }
}

