/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.client.screens.widgets.entries;

import fr.iglee42.createqualityoflife.client.screens.itemsconfig.ItemConfigScreen;
import fr.iglee42.createqualityoflife.client.screens.widgets.ArmorConfigScreenList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.createmod.catnip.lang.FontHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public class ValueEntry<T>
extends ArmorConfigScreenList.LabeledEntry {
    protected T value;
    protected String nbtKey;
    protected boolean editable = true;
    protected List<String> commentLines = new ArrayList<String>(List.of("."));
    private final BiFunction<ValueEntry<?>, List<ValueEntry<?>>, Boolean> enable;

    public ValueEntry(String label, T value, String nbtKey, String[] comments, BiFunction<ValueEntry<?>, List<ValueEntry<?>>, Boolean> enable) {
        super(label);
        this.value = value;
        this.nbtKey = nbtKey;
        this.enable = enable;
        this.labelTooltip.add(Component.m_237113_((String)label).m_130940_(ChatFormatting.WHITE));
        this.commentLines.addAll(Arrays.stream(comments).toList());
        this.labelTooltip.addAll(this.commentLines.stream().map(s -> s.equals(".") ? " " : s).map(Component::m_237113_).flatMap(stc -> FontHelper.cutTextComponent((Component)stc, (FontHelper.Palette)FontHelper.Palette.GRAY_AND_RED).stream()).toList());
    }

    @Override
    public void setEditable(boolean b) {
        this.editable = b;
        this.labelTooltip.clear();
        this.labelTooltip.add(this.label.getComponent().m_6881_().m_130940_(ChatFormatting.WHITE));
        this.labelTooltip.addAll(this.commentLines.stream().map(s -> s.equals(".") ? " " : s).map(Component::m_237113_).flatMap(stc -> FontHelper.cutTextComponent((Component)stc, (FontHelper.Palette)FontHelper.Palette.GRAY_AND_RED).stream()).toList());
        if (!b) {
            this.labelTooltip.add(Component.m_237113_((String)"Disabled by the config").m_130940_(ChatFormatting.RED));
        }
    }

    @Override
    public void m_6311_(GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
        super.m_6311_(graphics, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
    }

    @Override
    protected int getLabelWidth(int totalWidth) {
        return (int)((float)totalWidth * 0.4f) + 30;
    }

    public void setValue(@Nonnull T value) {
        this.value = value;
        this.onValueChange(value);
    }

    @Nonnull
    public T getValue() {
        return this.value;
    }

    public void onReset() {
        this.onValueChange(this.getValue());
    }

    public void onValueChange() {
        this.onValueChange(this.getValue());
    }

    public void onValueChange(T newValue) {
    }

    protected void bumpCog() {
        this.bumpCog(10.0f);
    }

    protected void bumpCog(float force) {
        ItemConfigScreen.cogSpin.bump(3, (double)force);
    }

    public String getNbtKey() {
        return this.nbtKey;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public BiFunction<ValueEntry<?>, List<ValueEntry<?>>, Boolean> getEnableFunction() {
        return this.enable;
    }
}

