/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.armors;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.armor.BaseArmorItem;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLArmorMaterials;
import fr.iglee42.createqualityoflife.utils.ArmorRenderType;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import fr.iglee42.createqualityoflife.utils.ShadowRadianceEffects;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class ShadowRadianceArmorItem
extends BaseArmorItem
implements QOLConfigurableItem {
    public ShadowRadianceArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super((ArmorMaterial)QOLArmorMaterials.SHADOW_RADIANCE, type, properties, CreateQOL.asResource("shadow_radiance"));
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.m_6883_(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    public void m_7373_(ItemStack stack, Level p_339594_, List<Component> components, TooltipFlag p_41424_) {
        if (!NBTConstants.getTooltipOrDefault(stack).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.effect").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237115_((String)this.providedEffect(stack).m_19481_()).m_130940_(ChatFormatting.YELLOW)));
        if (this.m_266204_().equals((Object)ArmorItem.Type.BOOTS)) {
            components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.diving").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.bootsDiving.get(), true, NBTConstants.getOrDefault(stack, "diving", false), false, true)));
            components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.belt_blocking").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState(true, true, NBTConstants.getOrDefault(stack, "belt", true), false, true)));
            components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.lava_walking").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.bootsLavaWalking.get(), true, NBTConstants.getOrDefault(stack, "lava", true), false, true)));
        } else if (this.m_266204_().equals((Object)ArmorItem.Type.LEGGINGS)) {
            components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.void_walk").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.voidWalking.get(), true, NBTConstants.getOrDefault(stack, "void_walk", false), false, true)));
            components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.step_height").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.stepHeight.get(), true, NBTConstants.getOrDefault(stack, "step_height", false), false, true)));
        }
        super.m_7373_(stack, p_339594_, components, p_41424_);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ARMOR;
    }

    @Override
    public MobEffect providedEffect(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return QOLConfigurableItem.super.providedEffect(stack);
        }
        ArmorItem it = (ArmorItem)item;
        return this.m_266204_().equals((Object)ArmorItem.Type.BOOTS) || this.m_266204_().equals((Object)ArmorItem.Type.LEGGINGS) ? NBTConstants.getEffectsOrDefault(stack, this.m_266204_().equals((Object)ArmorItem.Type.BOOTS) ? ShadowRadianceEffects.JUMP_BOOST : ShadowRadianceEffects.SPEED).getEffectHolder() : QOLConfigurableItem.super.providedEffect(stack);
    }

    @Override
    public List<ArmorRenderType> renderTypes(ItemStack stack) {
        return Arrays.asList(ArmorRenderType.ALL, ArmorRenderType.NONE);
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        ShadowRadianceEffects[] valids = (ShadowRadianceEffects[])Arrays.stream(ShadowRadianceEffects.values()).filter(ef -> ef.isValidForItem(stack)).toArray(ShadowRadianceEffects[]::new);
        list.add(new QOLConfigurableItem.Configuration<ShadowRadianceEffects>("Effect", NBTConstants.getEffectsOrDefault(stack, this.m_266204_().equals((Object)ArmorItem.Type.BOOTS) ? ShadowRadianceEffects.JUMP_BOOST : ShadowRadianceEffects.SPEED), "choosable_effects", QOLConfigurableItem.Configuration.ConfigType.ENUM, Arrays.asList("Define which mob effect should be provided.", "For this item, there is " + Component.m_237115_((String)valids[0].getEffectHolder().m_19481_()).getString() + " and " + Component.m_237115_((String)valids[1].getEffectHolder().m_19481_()).getString()), (direction, entry) -> {
            ShadowRadianceEffects e = (ShadowRadianceEffects)((Object)((Object)entry.getValue()));
            ShadowRadianceEffects[] options = (ShadowRadianceEffects[])Arrays.stream(ShadowRadianceEffects.values()).filter(ef -> ef.isValidForItem(stack)).toArray(ShadowRadianceEffects[]::new);
            e = options[Math.floorMod(e.ordinal() + direction, options.length)];
            return e;
        }, (e, oe) -> true));
        if (this.m_266204_().equals((Object)ArmorItem.Type.BOOTS)) {
            list.add(QOLConfigurableItem.Configuration.ofBool("Enable Diving", NBTConstants.getOrDefault(stack, "diving", false), "diving", List.of("Enable diving, which makes the player descends quicker in liquids"), (e, oE) -> (Boolean)CreateQOLConfigs.server().equipments.armors.bootsDiving.get()));
            list.add(QOLConfigurableItem.Configuration.ofBool("Enable Lava Walking", NBTConstants.getOrDefault(stack, "lava", true), "lava", List.of("Enable walking under lava, which makes the player walks normally under lava"), (e, oE) -> (Boolean)CreateQOLConfigs.server().equipments.armors.bootsLavaWalking.get()));
            list.add(QOLConfigurableItem.Configuration.ofBool("Enable Belt Blocking", NBTConstants.getOrDefault(stack, "belt", true), "belt", List.of("You won't be pushed by belt if enabled"), (e, oE) -> true));
        } else if (this.m_266204_() == ArmorItem.Type.LEGGINGS) {
            list.add(QOLConfigurableItem.Configuration.ofBool("Void Walking", NBTConstants.getOrDefault(stack, "void_walk", true), "void_walk", List.of("Enable walking on void"), (e, oE) -> (Boolean)CreateQOLConfigs.server().equipments.armors.voidWalking.get()));
            list.add(QOLConfigurableItem.Configuration.ofBool("Enable Step Height", NBTConstants.getOrDefault(stack, "step_height", true), "step_height", List.of("Should the leggings add step height"), (e, oE) -> (Boolean)CreateQOLConfigs.server().equipments.armors.stepHeight.get()));
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<T> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean m_142522_(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142158_(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142159_(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    @Override
    public Map<Holder<Attribute>, Map.Entry<Double, AttributeModifier.Operation>> getAppliedAttributes(ItemStack stack) {
        if (this.m_266204_().equals((Object)ArmorItem.Type.LEGGINGS)) {
            Map<Holder<Attribute>, Map.Entry<Double, AttributeModifier.Operation>> map = QOLConfigurableItem.super.getAppliedAttributes(stack);
            if (((Boolean)CreateQOLConfigs.server().equipments.armors.stepHeight.get()).booleanValue() && NBTConstants.getOrDefault(stack, "step_height", true)) {
                map.put((Holder<Attribute>)((Holder)ForgeMod.STEP_HEIGHT_ADDITION.getHolder().get()), new AbstractMap.SimpleEntry<Double, AttributeModifier.Operation>(0.5, AttributeModifier.Operation.ADDITION));
            }
            return map;
        }
        return QOLConfigurableItem.super.getAppliedAttributes(stack);
    }
}

