/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.armors;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.armor.BaseArmorItem;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLArmorMaterials;
import fr.iglee42.createqualityoflife.utils.ArmorRenderType;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ShadowSteelArmorItem
extends BaseArmorItem
implements QOLConfigurableItem {
    public ShadowSteelArmorItem(ArmorItem.Type type, Item.Properties properties) {
        super((ArmorMaterial)QOLArmorMaterials.SHADOW_STEEL, type, properties, CreateQOL.asResource("shadow_steel"));
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.m_6883_(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!NBTConstants.getTooltipOrDefault(stack).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        if (this.m_266204_().equals((Object)ArmorItem.Type.BOOTS)) {
            components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.diving").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.bootsDiving.get(), true, NBTConstants.getOrDefault(stack, "diving", false), false, true)));
            components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.lava_walking").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.bootsLavaWalking.get(), true, NBTConstants.getOrDefault(stack, "lava", true), false, true)));
        } else if (this.m_266204_().equals((Object)ArmorItem.Type.LEGGINGS)) {
            components.add((Component)Component.m_237110_((String)"createqol.ability.armor.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.armor.void_walk").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.armors.voidWalking.get(), true, NBTConstants.getOrDefault(stack, "void_walk", true), false, true)));
        }
        super.m_7373_(stack, p_41422_, components, p_41424_);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ARMOR;
    }

    @Override
    public MobEffect providedEffect(ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return QOLConfigurableItem.super.providedEffect(stack);
        }
        ArmorItem it = (ArmorItem)item;
        return this.m_266204_().equals((Object)ArmorItem.Type.BOOTS) ? MobEffects.f_19603_ : (this.m_266204_().equals((Object)ArmorItem.Type.LEGGINGS) ? MobEffects.f_19596_ : QOLConfigurableItem.super.providedEffect(stack));
    }

    @Override
    public List<ArmorRenderType> renderTypes(ItemStack stack) {
        return Arrays.asList(ArmorRenderType.ALL, ArmorRenderType.NONE);
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        if (this.m_266204_().equals((Object)ArmorItem.Type.BOOTS)) {
            list.add(QOLConfigurableItem.Configuration.ofBool("Enable Diving", NBTConstants.getOrDefault(stack, "diving", false), "diving", List.of("Enable diving, which makes the player descends quicker in liquids"), (e, oE) -> (Boolean)CreateQOLConfigs.server().equipments.armors.bootsDiving.get()));
            list.add(QOLConfigurableItem.Configuration.ofBool("Enable Lava Walking", NBTConstants.getOrDefault(stack, "lava", true), "lava", List.of("Enable walking under lava, which makes the player walks normally under lava"), (e, oE) -> (Boolean)CreateQOLConfigs.server().equipments.armors.bootsLavaWalking.get()));
        } else if (this.m_266204_() == ArmorItem.Type.LEGGINGS) {
            list.add(QOLConfigurableItem.Configuration.ofBool("Void Walking", NBTConstants.getOrDefault(stack, "void_walk", true), "void_walk", List.of("Enable walking on void"), (e, oE) -> (Boolean)CreateQOLConfigs.server().equipments.armors.voidWalking.get()));
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<T> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean m_142522_(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142158_(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142159_(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }
}

