/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.tools.refinedradiance;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLItems;
import fr.iglee42.createqualityoflife.registries.QOLTiers;
import fr.iglee42.createqualityoflife.utils.DestroyUtils;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.data.Iterate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.level.BlockEvent;
import org.jetbrains.annotations.Nullable;

public class RefinedRadiancePickaxe
extends PickaxeItem
implements QOLConfigurableItem {
    public RefinedRadiancePickaxe(Item.Properties p_42964_) {
        super((Tier)QOLTiers.REFINED_RADIANCE, 1, -2.8f, p_42964_);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.m_6883_(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ITEM;
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!NBTConstants.getTooltipOrDefault(stack).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.m_237110_((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.tool.reach").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.reach.get(), true, NBTConstants.getOrDefault(stack, "reach", true), false, true)));
        components.add((Component)Component.m_237110_((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.tool.vein_mine").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.veinMine.get(), true, NBTConstants.getOrDefault(stack, "vein_mine", false), false, true)));
        super.m_7373_(stack, p_41422_, components, p_41424_);
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Vein Mine", NBTConstants.getOrDefault(stack, "vein_mine", false), "vein_mine", List.of("Should all the blocks of the same types be destroy when mining"), (e, oe) -> (Boolean)CreateQOLConfigs.server().equipments.tools.veinMine.get()));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.f_46443_) {
            return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)true);
        }
        if (player.m_6047_()) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        RefinedRadiancePickaxe.toggleAbility(player.m_21120_(hand), player);
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public static void toggleAbility(ItemStack stack, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.veinMine.get()).booleanValue()) {
            p.m_5661_((Component)CreateQOLLang.translateDirect("ability.tool.disabled", CreateQOLLang.translateDirect("ability.tool.vein_mine", new Object[0]).getString()).m_130940_(ChatFormatting.RED), true);
            return;
        }
        boolean enable = !NBTConstants.getOrDefault(stack, "vein_mine", false);
        stack.m_41784_().m_128379_("vein_mine", enable);
        p.m_5661_((Component)CreateQOLLang.translateDirect("ability.tool.toggle_message", CreateQOLLang.translateDirect("ability.tool.vein_mine", new Object[0]).getString()).m_7220_(QOLConfigurableItem.chooseState(true, true, enable, false, true)).m_130940_(enable ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<T> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean m_142522_(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142158_(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142159_(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public static void mineBlock(BlockEvent.BreakEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!event.getPlayer().m_21205_().m_150930_((Item)QOLItems.REFINED_RADIANCE_PICKAXE.get()) && !event.getPlayer().m_21205_().m_150930_((Item)QOLItems.SHADOW_RADIANCE_PICKAXE.get())) {
            return;
        }
        if (!NBTConstants.getOrDefault(event.getPlayer().m_21205_(), "vein_mine", false)) {
            return;
        }
        if (!event.getPlayer().m_21205_().m_41735_(event.getState())) {
            return;
        }
        int max = (Integer)CreateQOLConfigs.server().equipments.tools.veinMineMaxBlocks.get();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        ArrayDeque<BlockPos> toExplore = new ArrayDeque<BlockPos>();
        List<BlockPos> first = RefinedRadiancePickaxe.getValidBlocksNextTo(event.getLevel(), event.getPos(), event.getPlayer().m_21205_());
        for (BlockPos pos : first) {
            if (!event.getLevel().m_8055_(pos).m_60713_(event.getState().m_60734_())) continue;
            visited.add(pos);
            toExplore.add(pos);
            if (visited.size() < max) continue;
            break;
        }
        block1: while (!toExplore.isEmpty() && visited.size() < max) {
            BlockPos current = (BlockPos)toExplore.poll();
            List<BlockPos> neighbors = RefinedRadiancePickaxe.getValidBlocksNextTo(event.getLevel(), current, event.getPlayer().m_21205_());
            for (BlockPos neighbor : neighbors) {
                if (visited.size() >= max) continue block1;
                if (visited.contains(neighbor) || !event.getLevel().m_8055_(neighbor).m_60713_(event.getState().m_60734_())) continue;
                visited.add(neighbor);
                toExplore.add(neighbor);
            }
        }
        visited.forEach(p -> DestroyUtils.destroyBlock(event.getPlayer().m_9236_(), ((ServerPlayer)event.getPlayer()).f_8941_.m_9290_(), event.getPlayer(), ((ServerPlayer)event.getPlayer()).f_8941_, p, event.getPos()));
    }

    private static List<BlockPos> getValidBlocksNextTo(LevelAccessor level, BlockPos pos, ItemStack stack) {
        ArrayList<BlockPos> poses = new ArrayList<BlockPos>();
        for (Direction direction : Iterate.directions) {
            if (!stack.m_41735_(level.m_8055_(pos.m_121945_(direction)))) continue;
            poses.add(pos.m_121945_(direction));
        }
        return poses;
    }

    @Override
    public QOLConfigurableItem.ReachType reachType(ItemStack stack) {
        return QOLConfigurableItem.ReachType.BLOCK;
    }
}

