/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.tools.shadowradiance;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLTiers;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShadowRadianceSword
extends SwordItem
implements QOLConfigurableItem {
    public ShadowRadianceSword(Item.Properties p_42964_) {
        super((Tier)QOLTiers.SHADOW_RADIANCE, 3, -2.4f, p_42964_);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19090_((Object)itemstack);
    }

    @NotNull
    public UseAnim m_6164_(ItemStack p_41452_) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack p_41454_) {
        return (Integer)CreateQOLConfigs.server().equipments.tools.swordsChargeTime.get();
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity lvEntity, int remainingTime) {
        if (!(lvEntity instanceof Player)) {
            return;
        }
        Player player = (Player)lvEntity;
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.swordsAbilities.get()).booleanValue()) {
            return;
        }
        if ((Integer)CreateQOLConfigs.server().equipments.tools.swordsAirConsumption.get() > 0 && !player.m_7500_()) {
            ItemStack backtank = BacktankUtil.getAllWithAir((LivingEntity)player).stream().filter(i -> BacktankUtil.getAir((ItemStack)i) >= (float)((Integer)CreateQOLConfigs.server().equipments.tools.swordsAirConsumption.get()).intValue()).findFirst().orElse(ItemStack.f_41583_);
            if (backtank.m_41619_()) {
                return;
            }
            BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)backtank, (float)((Integer)CreateQOLConfigs.server().equipments.tools.swordsAirConsumption.get()).intValue());
        }
        int usedTime = this.m_8105_(stack) - remainingTime;
        float timeRatio = (float)usedTime / (float)this.m_8105_(stack);
        if (!level.f_46443_) {
            Vec3 playerPos = player.m_20182_();
            double radius = (Double)CreateQOLConfigs.server().equipments.tools.swordsRadius.get();
            double strength = (Double)CreateQOLConfigs.server().equipments.tools.swordsStrength.get() * (double)timeRatio;
            AABB area = new AABB(playerPos.f_82479_ - radius, playerPos.f_82480_ - radius, playerPos.f_82481_ - radius, playerPos.f_82479_ + radius, playerPos.f_82480_ + radius, playerPos.f_82481_ + radius);
            List entities = level.m_6443_(LivingEntity.class, area, entity -> entity != player && entity.m_6084_());
            for (LivingEntity entity2 : entities) {
                Vec3 direction;
                double scaledStrength;
                double distance;
                Vec3 toPlayer;
                if (player.m_6047_()) {
                    toPlayer = playerPos.m_82546_(entity2.m_20182_());
                    distance = toPlayer.m_82553_();
                    if (distance <= 0.1) continue;
                    scaledStrength = (1.0 - distance / radius) * strength;
                    direction = entity2.m_20182_().m_82546_(playerPos).m_82541_().m_82490_(scaledStrength);
                    entity2.m_5997_(direction.f_82479_, 0.3, direction.f_82481_);
                    continue;
                }
                toPlayer = playerPos.m_82546_(entity2.m_20182_());
                distance = toPlayer.m_82553_();
                if (distance <= 0.1) continue;
                scaledStrength = distance / radius * strength;
                direction = toPlayer.m_82541_().m_82490_(scaledStrength);
                entity2.m_5997_(direction.f_82479_, 0.3, direction.f_82481_);
            }
            player.m_21011_(InteractionHand.MAIN_HAND, true);
            player.m_36335_().m_41524_((Item)this, ((Integer)CreateQOLConfigs.server().equipments.tools.swordsCooldowns.get()).intValue());
        } else {
            Vec3 baseMotion = new Vec3((Double)CreateQOLConfigs.server().equipments.tools.swordsRadius.get() / 4.0, 0.1, 0.0);
            for (int i2 = 0; i2 < 360; i2 += 10) {
                Vec3 v;
                Vec3 m;
                if (!player.m_6047_()) {
                    m = VecHelper.rotate((Vec3)baseMotion, (double)i2, (Direction.Axis)Direction.Axis.Y);
                    v = player.m_20182_().m_82520_(m.f_82479_, 0.0, m.f_82481_);
                    Vec3 mo = m.m_82541_().m_82490_(-0.5).m_82520_(0.0, 0.3, 0.0);
                    level.m_7106_((ParticleOptions)ParticleTypes.f_123764_, v.f_82479_, v.f_82480_, v.f_82481_, mo.f_82479_, mo.f_82480_, mo.f_82481_);
                    continue;
                }
                m = VecHelper.rotate((Vec3)baseMotion, (double)i2, (Direction.Axis)Direction.Axis.Y);
                v = player.m_20182_().m_82549_(m.m_82541_().m_82490_(0.25));
                level.m_7106_((ParticleOptions)ParticleTypes.f_123764_, v.f_82479_, v.f_82480_, v.f_82481_, m.f_82479_, m.f_82480_, m.f_82481_);
            }
        }
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.m_6883_(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ITEM;
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!NBTConstants.getTooltipOrDefault(stack).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.m_237110_((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.tool.reach").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.reach.get(), true, NBTConstants.getOrDefault(stack, "reach", true), false, true)));
        components.add((Component)Component.m_237110_((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.tool.repulsion_attraction").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.cooldownState((Boolean)CreateQOLConfigs.server().equipments.tools.swordsAbilities.get(), true, (int)Math.ceil(Minecraft.m_91087_().f_91074_.m_36335_().m_41521_((Item)this, 0.0f) * (float)((Integer)CreateQOLConfigs.server().equipments.tools.swordsCooldowns.get()).intValue()))));
        super.m_7373_(stack, p_41422_, components, p_41424_);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<T> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean m_142522_(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142158_(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142159_(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    @Override
    public QOLConfigurableItem.ReachType reachType(ItemStack stack) {
        return QOLConfigurableItem.ReachType.ENTITY;
    }

    @Override
    public double reachModifier(ItemStack stack) {
        return 1.0;
    }
}

