/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.items.tools.shadowsteel;

import com.simibubi.create.content.equipment.armor.BacktankUtil;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.registries.QOLItems;
import fr.iglee42.createqualityoflife.registries.QOLTiers;
import fr.iglee42.createqualityoflife.utils.DestroyUtils;
import fr.iglee42.createqualityoflife.utils.ItemTooltips;
import fr.iglee42.createqualityoflife.utils.NBTConstants;
import fr.iglee42.createqualityoflife.utils.QOLConfigurableItem;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.level.BlockEvent;
import org.jetbrains.annotations.Nullable;

public class ShadowSteelShovel
extends ShovelItem
implements QOLConfigurableItem {
    public ShadowSteelShovel(Item.Properties p_42964_) {
        super((Tier)QOLTiers.SHADOW_STEEL, 1.5f, -3.0f, p_42964_);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean offHand) {
        super.m_6883_(stack, level, entity, slot, offHand);
        this.invTick(stack, level, entity, slot, offHand);
    }

    @Override
    public QOLConfigurableItem.Type type() {
        return QOLConfigurableItem.Type.ITEM;
    }

    public void m_7373_(ItemStack stack, @Nullable Level p_41422_, List<Component> components, TooltipFlag p_41424_) {
        if (!NBTConstants.getTooltipOrDefault(stack).isEnable(ItemTooltips.Tooltip.OPTIONS)) {
            return;
        }
        components.add((Component)Component.m_237110_((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.tool.reach").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.reach.get(), true, NBTConstants.getOrDefault(stack, "reach", true), false, true)));
        components.add((Component)Component.m_237110_((String)"createqol.ability.tool.toggle_message", (Object[])new Object[]{Component.m_237115_((String)"createqol.ability.tool.digging").getString()}).m_130940_(ChatFormatting.GOLD).m_7220_(QOLConfigurableItem.chooseState((Boolean)CreateQOLConfigs.server().equipments.tools.digging.get(), true, NBTConstants.getOrDefault(stack, "digging", false), false, true)));
        super.m_7373_(stack, p_41422_, components, p_41424_);
    }

    @Override
    public void addConfigurations(List<QOLConfigurableItem.Configuration<?>> list, ItemStack stack) {
        list.add(QOLConfigurableItem.Configuration.ofBool("Digging", NBTConstants.getOrDefault(stack, "digging", false), "digging", List.of("Activate the 3x3x3 digging when mining a block"), (e, oe) -> (Boolean)CreateQOLConfigs.server().equipments.tools.digging.get()));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (level.f_46443_) {
            return InteractionResultHolder.m_19092_((Object)player.m_21120_(hand), (boolean)true);
        }
        if (player.m_6047_()) {
            return InteractionResultHolder.m_19098_((Object)player.m_21120_(hand));
        }
        ShadowSteelShovel.toggleAbility(player.m_21120_(hand), player);
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(hand));
    }

    public static void toggleAbility(ItemStack stack, Player p) {
        if (!((Boolean)CreateQOLConfigs.server().equipments.tools.digging.get()).booleanValue()) {
            p.m_5661_((Component)CreateQOLLang.translateDirect("ability.tool.disabled", CreateQOLLang.translateDirect("ability.tool.digging", new Object[0]).getString()).m_130940_(ChatFormatting.RED), true);
            return;
        }
        boolean enable = !NBTConstants.getOrDefault(stack, "digging", false);
        stack.m_41784_().m_128379_("digging", enable);
        p.m_5661_((Component)CreateQOLLang.translateDirect("ability.tool.toggle_message", CreateQOLLang.translateDirect("ability.tool.digging", new Object[0]).getString()).m_7220_(QOLConfigurableItem.chooseState(true, true, enable, false, true)).m_130940_(enable ? ChatFormatting.GREEN : ChatFormatting.RED), true);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, @Nullable T entity, Consumer<T> onBroken) {
        if (BacktankUtil.canAbsorbDamage(entity, (int)this.getMaxDamage(stack))) {
            return 0;
        }
        return super.damageItem(stack, amount, entity, onBroken);
    }

    public boolean m_142522_(ItemStack stack) {
        return BacktankUtil.isBarVisible((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142158_(ItemStack stack) {
        return BacktankUtil.getBarWidth((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public int m_142159_(ItemStack stack) {
        return BacktankUtil.getBarColor((ItemStack)stack, (int)this.getMaxDamage(stack));
    }

    public static void mineBlock(BlockEvent.BreakEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!event.getPlayer().m_21205_().m_150930_((Item)QOLItems.SHADOW_STEEL_SHOVEL.get()) && !event.getPlayer().m_21205_().m_150930_((Item)QOLItems.SHADOW_RADIANCE_SHOVEL.get())) {
            return;
        }
        if (!NBTConstants.getOrDefault(event.getPlayer().m_21205_(), "digging", false)) {
            return;
        }
        if (!event.getPlayer().m_21205_().m_41735_(event.getState())) {
            return;
        }
        BlockPos startPos = event.getPos();
        Direction dir = ShadowSteelShovel.getTargetedBlockFace((ServerPlayer)event.getPlayer());
        if (dir == null) {
            return;
        }
        for (int y = 0; y <= 2; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos offsetPos = startPos.m_5484_(dir.m_122424_(), y);
                    if (dir.m_122434_().equals((Object)Direction.Axis.Y)) {
                        offsetPos = offsetPos.m_7918_(x, 0, z);
                    } else if (dir.m_122434_().equals((Object)Direction.Axis.Z)) {
                        offsetPos = offsetPos.m_7918_(x, z, 0);
                    } else if (dir.m_122434_().equals((Object)Direction.Axis.X)) {
                        offsetPos = offsetPos.m_7918_(0, x, z);
                    }
                    BlockState cState = event.getLevel().m_8055_(offsetPos);
                    if (!event.getPlayer().m_21205_().m_41735_(cState)) continue;
                    DestroyUtils.destroyBlock(event.getPlayer().m_9236_(), ((ServerPlayer)event.getPlayer()).f_8941_.m_9290_(), event.getPlayer(), ((ServerPlayer)event.getPlayer()).f_8941_, offsetPos, event.getPos());
                }
            }
        }
    }

    public static Direction getTargetedBlockFace(ServerPlayer player) {
        double reach;
        Vec3 lookVec;
        Vec3 reachVec;
        Vec3 eyePos;
        ClipContext context;
        Level level = player.m_9236_();
        BlockHitResult hitResult = level.m_45547_(context = new ClipContext(eyePos = player.m_20299_(1.0f), reachVec = eyePos.m_82549_((lookVec = player.m_20252_(1.0f)).m_82490_(reach = player.m_21133_((Attribute)ForgeMod.BLOCK_REACH.get()))), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            return hitResult.m_82434_();
        }
        return null;
    }

    @Override
    public QOLConfigurableItem.ReachType reachType(ItemStack stack) {
        return QOLConfigurableItem.ReachType.BLOCK;
    }
}

