/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.mixins;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.packagerLink.LogisticsNetwork;
import fr.iglee42.createqualityoflife.utils.LogisticsNetworkExtension;
import fr.iglee42.createqualityoflife.utils.NetworkDestructionLevel;
import fr.iglee42.createqualityoflife.utils.NetworkPermission;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LogisticsNetwork.class}, remap=false)
public class LogisticsNetworkMixin
implements LogisticsNetworkExtension {
    @Unique
    private String createQOL$name = "Unnamed Network";
    @Unique
    private NetworkDestructionLevel createQOL$destructionLevel = NetworkDestructionLevel.ALL;
    @Unique
    private Map<UUID, NetworkPermission> createQOL$permissions = new HashMap<UUID, NetworkPermission>();

    @Override
    public String createQOL$getName() {
        return this.createQOL$name;
    }

    @Override
    public void createQOL$setName(String name) {
        this.createQOL$name = name;
        Create.LOGISTICS.markDirty();
    }

    @Override
    public NetworkDestructionLevel createQOL$getDestructionLevel() {
        return this.createQOL$destructionLevel;
    }

    @Override
    public void createQOL$setDestructionLevel(NetworkDestructionLevel level) {
        this.createQOL$destructionLevel = level;
        Create.LOGISTICS.markDirty();
    }

    @Override
    public Map<UUID, NetworkPermission> createQOL$getPlayersPermission() {
        return this.createQOL$permissions;
    }

    @Override
    public void createQOL$setPlayersPermission(Map<UUID, NetworkPermission> permissions) {
        this.createQOL$permissions = permissions;
        Create.LOGISTICS.markDirty();
    }

    @Inject(method={"read"}, at={@At(value="RETURN")}, cancellable=true)
    private static void createQOL$addNewFieldsToRead(CompoundTag tag, CallbackInfoReturnable<LogisticsNetwork> cir) {
        LogisticsNetwork network = (LogisticsNetwork)cir.getReturnValue();
        if (tag.m_128441_("Name")) {
            ((LogisticsNetworkExtension)network).createQOL$setName(tag.m_128461_("Name"));
        }
        if (tag.m_128441_("DestructionLevel")) {
            ((LogisticsNetworkExtension)network).createQOL$setDestructionLevel(NetworkDestructionLevel.values()[tag.m_128445_("DestructionLevel")]);
        }
        if (tag.m_128441_("Permissions")) {
            HashMap permissions = new HashMap();
            CompoundTag permissionTags = tag.m_128469_("Permissions");
            permissionTags.m_128431_().stream().map(k -> {
                UUID uuid = UUID.fromString(k);
                NetworkPermission permission = NetworkPermission.values()[permissionTags.m_128451_(k)];
                return new AbstractMap.SimpleEntry<UUID, NetworkPermission>(uuid, permission);
            }).forEach(e -> permissions.put((UUID)e.getKey(), (NetworkPermission)((Object)((Object)e.getValue()))));
            ArrayList toRemove = new ArrayList();
            HashMap<UUID, NetworkPermission> newPerms = new HashMap<UUID, NetworkPermission>(permissions);
            newPerms.keySet().stream().filter(k -> ((NetworkPermission)((Object)((Object)newPerms.get(k)))).equals((Object)NetworkPermission.OWNER) || ((NetworkPermission)((Object)((Object)newPerms.get(k)))).equals((Object)NetworkPermission.NONE)).forEach(toRemove::add);
            toRemove.forEach(newPerms::remove);
            ((LogisticsNetworkExtension)network).createQOL$setPlayersPermission(newPerms);
        }
        cir.setReturnValue((Object)network);
    }

    @Inject(method={"write"}, at={@At(value="RETURN")}, cancellable=true)
    private void createQOL$addNewFieldsToWrite(CallbackInfoReturnable<CompoundTag> cir) {
        CompoundTag tag = (CompoundTag)cir.getReturnValue();
        tag.m_128359_("Name", this.createQOL$getName());
        tag.m_128344_("DestructionLevel", (byte)this.createQOL$getDestructionLevel().ordinal());
        CompoundTag perms = new CompoundTag();
        this.createQOL$getPlayersPermission().forEach((id, perm) -> perms.m_128405_(id.toString(), perm.ordinal()));
        tag.m_128365_("Permissions", (Tag)perms);
        cir.setReturnValue((Object)tag);
    }
}

