/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.packets;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.packagerLink.LogisticsNetwork;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import fr.iglee42.createqualityoflife.blockentitites.StockManagerBlockEntity;
import fr.iglee42.createqualityoflife.utils.LogisticsNetworkExtension;
import fr.iglee42.createqualityoflife.utils.NetworkPermission;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ModifyPlayerNetworkPermissionPacket
extends BlockEntityConfigurationPacket<StockManagerBlockEntity> {
    private UUID modifiedPlayer;
    private NetworkPermission permission;

    public ModifyPlayerNetworkPermissionPacket(BlockPos pos, UUID modifiedPlayer, NetworkPermission permission) {
        super(pos);
        this.modifiedPlayer = modifiedPlayer;
        this.permission = permission;
    }

    public ModifyPlayerNetworkPermissionPacket(FriendlyByteBuf buffer) {
        super(buffer);
    }

    protected void writeSettings(FriendlyByteBuf buffer) {
        buffer.m_130077_(this.modifiedPlayer);
        buffer.m_130068_((Enum)this.permission);
    }

    protected void readSettings(FriendlyByteBuf buffer) {
        this.modifiedPlayer = buffer.m_130259_();
        this.permission = (NetworkPermission)buffer.m_130066_(NetworkPermission.class);
    }

    protected void applySettings(ServerPlayer player, StockManagerBlockEntity be) {
        LogisticsNetwork network = (LogisticsNetwork)Create.LOGISTICS.logisticsNetworks.get(be.behaviour.freqId);
        if (network != null) {
            LogisticsNetworkExtension extendedNetwork = (LogisticsNetworkExtension)network;
            NetworkPermission currentPerm = extendedNetwork.createQOL$getPlayerPermission(this.modifiedPlayer);
            if (currentPerm.equals((Object)NetworkPermission.NONE) && this.permission == NetworkPermission.MEMBER && extendedNetwork.createQOL$hasPlayerPermission((Player)player, NetworkPermission.ADMIN)) {
                ((LogisticsNetworkExtension)network).createQOL$modifyPlayerPermission(this.modifiedPlayer, this.permission);
                Create.LOGISTICS.markDirty();
            }
            if (currentPerm.equals((Object)NetworkPermission.ADMIN) && this.permission == NetworkPermission.MEMBER && player.m_20148_().equals(network.owner)) {
                ((LogisticsNetworkExtension)network).createQOL$modifyPlayerPermission(this.modifiedPlayer, this.permission);
                Create.LOGISTICS.markDirty();
            }
            if (currentPerm.equals((Object)NetworkPermission.MEMBER) && this.permission == NetworkPermission.NONE && extendedNetwork.createQOL$hasPlayerPermission((Player)player, NetworkPermission.ADMIN)) {
                ((LogisticsNetworkExtension)network).createQOL$modifyPlayerPermission(this.modifiedPlayer, this.permission);
                Create.LOGISTICS.markDirty();
            }
            if (currentPerm.equals((Object)NetworkPermission.MEMBER) && this.permission == NetworkPermission.ADMIN && player.m_20148_().equals(network.owner)) {
                ((LogisticsNetworkExtension)network).createQOL$modifyPlayerPermission(this.modifiedPlayer, this.permission);
                Create.LOGISTICS.markDirty();
            }
        }
    }

    protected void applySettings(StockManagerBlockEntity stockManagerBlockEntity) {
    }
}

