/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.packets;

import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.packagerLink.LogisticsNetwork;
import com.simibubi.create.foundation.networking.BlockEntityConfigurationPacket;
import fr.iglee42.createqualityoflife.blockentitites.StockManagerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class StockManagerLockPacket
extends BlockEntityConfigurationPacket<StockManagerBlockEntity> {
    private boolean lock;

    public StockManagerLockPacket(BlockPos pos, boolean lock) {
        super(pos);
        this.lock = lock;
    }

    public StockManagerLockPacket(FriendlyByteBuf buffer) {
        super(buffer);
    }

    protected void readSettings(FriendlyByteBuf buffer) {
        this.lock = buffer.readBoolean();
    }

    protected void writeSettings(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.lock);
    }

    protected void applySettings(ServerPlayer player, StockManagerBlockEntity be) {
        if (!be.behaviour.mayAdministrate((Player)player)) {
            return;
        }
        LogisticsNetwork network = (LogisticsNetwork)Create.LOGISTICS.logisticsNetworks.get(be.behaviour.freqId);
        if (network != null) {
            network.locked = this.lock;
            Create.LOGISTICS.markDirty();
        }
    }

    protected void applySettings(StockManagerBlockEntity stockManagerBlockEntity) {
    }
}

