/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.packets;

import com.simibubi.create.foundation.networking.SimplePacketBase;
import fr.iglee42.createqualityoflife.utils.CommonKeysHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class UpdateInputsPacket
extends SimplePacketBase {
    private final boolean up;
    private final boolean down;
    private final boolean forwards;
    private final boolean backwards;
    private final boolean left;
    private final boolean right;

    public UpdateInputsPacket(boolean up, boolean down, boolean forwards, boolean backwards, boolean left, boolean right) {
        this.up = up;
        this.down = down;
        this.forwards = forwards;
        this.backwards = backwards;
        this.left = left;
        this.right = right;
    }

    public UpdateInputsPacket(FriendlyByteBuf buffer) {
        this(buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean(), buffer.readBoolean());
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.up);
        buffer.writeBoolean(this.down);
        buffer.writeBoolean(this.forwards);
        buffer.writeBoolean(this.backwards);
        buffer.writeBoolean(this.left);
        buffer.writeBoolean(this.right);
    }

    public boolean handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player != null) {
                CommonKeysHandler.update((Player)player, this.up, this.down, this.forwards, this.backwards, this.left, this.right);
            }
        });
        return true;
    }
}

