/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.statue;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueHandler;
import fr.iglee42.createqualityoflife.CreateQOLLang;
import fr.iglee42.createqualityoflife.registries.QOLEntityDataSerializers;
import fr.iglee42.createqualityoflife.registries.QOLEntityTypes;
import fr.iglee42.createqualityoflife.registries.QOLItems;
import fr.iglee42.createqualityoflife.statue.StatueMenu;
import fr.iglee42.createqualityoflife.statue.animation.StatueAnimation;
import fr.iglee42.createqualityoflife.statue.animation.StatueAnimationFrame;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Rotations;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Statue
extends LivingEntity {
    public static final float DEFAULT_SCALE = 1.0f;
    public static final Rotations DEFAULT_ENTITY_ROTATIONS = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_HEAD_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_BODY_POSE = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFT_ARM_POSE = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations DEFAULT_RIGHT_ARM_POSE = new Rotations(-15.0f, 0.0f, 10.0f);
    private static final Rotations DEFAULT_LEFT_LEG_POSE = new Rotations(-1.0f, 0.0f, -1.0f);
    private static final Rotations DEFAULT_RIGHT_LEG_POSE = new Rotations(1.0f, 0.0f, 1.0f);
    private static final EntityDimensions MARKER_DIMENSIONS = EntityDimensions.m_20398_((float)0.0f, (float)0.0f);
    private static final EntityDimensions BABY_DIMENSIONS = EntityType.f_20529_.m_20680_().m_20388_(0.5f);
    public static final EntityDataAccessor<Boolean> DATA_INVULNERABLE = SynchedEntityData.m_135353_(Statue.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Byte> DATA_CLIENT_FLAGS = SynchedEntityData.m_135353_(Statue.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Rotations> DATA_HEAD_POSE = SynchedEntityData.m_135353_(Statue.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_BODY_POSE = SynchedEntityData.m_135353_(Statue.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_ARM_POSE = SynchedEntityData.m_135353_(Statue.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_ARM_POSE = SynchedEntityData.m_135353_(Statue.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_LEG_POSE = SynchedEntityData.m_135353_(Statue.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_LEG_POSE = SynchedEntityData.m_135353_(Statue.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_GLOBAL_ROTATIONS = SynchedEntityData.m_135353_(Statue.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Byte> DATA_PLAYER_SKIN_CUSTOMISATION = SynchedEntityData.m_135353_(Statue.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Optional<UUID>> DATA_OWNER = SynchedEntityData.m_135353_(Statue.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    public static final EntityDataAccessor<Optional<GameProfile>> DATA_PROFILE = SynchedEntityData.m_135353_(Statue.class, QOLEntityDataSerializers.PROFILE_ENTITY_DATA_SERIALIZER);
    public static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(Statue.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Optional<StatueAnimation>> DATA_ANIMATION = SynchedEntityData.m_135353_(Statue.class, QOLEntityDataSerializers.ANIMATION_DATA_SERIALIZER);
    public static final EntityDataAccessor<Integer> DATA_ANIMATION_PROGRESS = SynchedEntityData.m_135353_(Statue.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Boolean> DATA_ANIMATION_REVERSING = SynchedEntityData.m_135353_(Statue.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_ANIMATION_PLAYING = SynchedEntityData.m_135353_(Statue.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DATA_SKIN = SynchedEntityData.m_135353_(Statue.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Predicate<Entity> RIDABLE_MINECARTS = p_31582_ -> p_31582_ instanceof AbstractMinecart && ((AbstractMinecart)p_31582_).canBeRidden();
    private final NonNullList<ItemStack> handItems = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> armorItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private boolean invisible;
    public long lastHit;
    private Rotations headPose = DEFAULT_HEAD_POSE;
    private Rotations bodyPose = DEFAULT_BODY_POSE;
    private Rotations leftArmPose = DEFAULT_LEFT_ARM_POSE;
    private Rotations rightArmPose = DEFAULT_RIGHT_ARM_POSE;
    private Rotations leftLegPose = DEFAULT_LEFT_LEG_POSE;
    private Rotations rightLegPose = DEFAULT_RIGHT_LEG_POSE;
    public float entityScaleO = 1.0f;
    public Rotations entityRotationsO = DEFAULT_ENTITY_ROTATIONS;

    public Statue(EntityType<? extends LivingEntity> p_31553_, Level p_31554_) {
        super(p_31553_, p_31554_);
    }

    public Statue(Level p_31556_, double p_31557_, double p_31558_, double p_31559_) {
        this((EntityType<? extends LivingEntity>)((EntityType)QOLEntityTypes.STATUE.get()), p_31556_);
        this.m_6034_(p_31557_, p_31558_, p_31559_);
    }

    public void m_6075_() {
        super.m_6075_();
        this.entityScaleO = this.getEntityScale();
        this.entityRotationsO = this.getEntityRotations();
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    private boolean hasPhysics() {
        return !this.isMarker() && !this.m_20068_();
    }

    public boolean m_21515_() {
        return super.m_21515_() && this.hasPhysics();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_INVULNERABLE, (Object)false);
        this.f_19804_.m_135372_(DATA_CLIENT_FLAGS, (Object)0);
        this.f_19804_.m_135372_(DATA_HEAD_POSE, (Object)DEFAULT_HEAD_POSE);
        this.f_19804_.m_135372_(DATA_BODY_POSE, (Object)DEFAULT_BODY_POSE);
        this.f_19804_.m_135372_(DATA_LEFT_ARM_POSE, (Object)DEFAULT_LEFT_ARM_POSE);
        this.f_19804_.m_135372_(DATA_RIGHT_ARM_POSE, (Object)DEFAULT_RIGHT_ARM_POSE);
        this.f_19804_.m_135372_(DATA_LEFT_LEG_POSE, (Object)DEFAULT_LEFT_LEG_POSE);
        this.f_19804_.m_135372_(DATA_RIGHT_LEG_POSE, (Object)DEFAULT_RIGHT_LEG_POSE);
        this.f_19804_.m_135372_(DATA_GLOBAL_ROTATIONS, (Object)DEFAULT_ENTITY_ROTATIONS);
        this.f_19804_.m_135372_(DATA_PLAYER_SKIN_CUSTOMISATION, (Object)Statue.getAllModelParts());
        this.f_19804_.m_135372_(DATA_PROFILE, Optional.empty());
        this.f_19804_.m_135372_(DATA_OWNER, Optional.empty());
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(1.0f));
        this.f_19804_.m_135372_(DATA_ANIMATION, Optional.empty());
        this.f_19804_.m_135372_(DATA_ANIMATION_PROGRESS, (Object)0);
        this.f_19804_.m_135372_(DATA_ANIMATION_REVERSING, (Object)false);
        this.f_19804_.m_135372_(DATA_ANIMATION_PLAYING, (Object)false);
        this.f_19804_.m_135372_(DATA_SKIN, (Object)0);
    }

    private static byte getAllModelParts() {
        byte value = 0;
        for (PlayerModelPart modelPart : PlayerModelPart.values()) {
            value = (byte)(value | modelPart.m_36445_());
        }
        return value;
    }

    public Iterable<ItemStack> m_6167_() {
        return this.handItems;
    }

    public Iterable<ItemStack> m_6168_() {
        return this.armorItems;
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        switch (slot.m_20743_()) {
            case HAND: {
                return (ItemStack)this.handItems.get(slot.m_20749_());
            }
            case ARMOR: {
                return (ItemStack)this.armorItems.get(slot.m_20749_());
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot p_31584_, ItemStack p_31585_) {
        this.m_181122_(p_31585_);
        switch (p_31584_.m_20743_()) {
            case HAND: {
                this.m_238392_(p_31584_, (ItemStack)this.handItems.set(p_31584_.m_20749_(), (Object)p_31585_), p_31585_);
                break;
            }
            case ARMOR: {
                this.m_238392_(p_31584_, (ItemStack)this.armorItems.set(p_31584_.m_20749_(), (Object)p_31585_), p_31585_);
            }
        }
    }

    public boolean m_7066_(ItemStack p_31638_) {
        EquipmentSlot equipmentslot = Statue.m_147233_((ItemStack)p_31638_);
        return this.m_6844_(equipmentslot).m_41619_();
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        ListTag listtag = new ListTag();
        for (ItemStack itemstack : this.armorItems) {
            listtag.add((Object)itemstack.m_41739_(new CompoundTag()));
        }
        nbt.m_128365_("ArmorItems", (Tag)listtag);
        ListTag listtag1 = new ListTag();
        for (ItemStack itemstack1 : this.handItems) {
            listtag1.add((Object)itemstack1.m_41739_(new CompoundTag()));
        }
        nbt.m_128365_("HandItems", (Tag)listtag1);
        nbt.m_128379_("Invisible", this.m_20145_());
        nbt.m_128379_("Small", this.isSmall());
        nbt.m_128379_("SlimArms", this.isSlimArms());
        nbt.m_128379_("ShowArms", this.isShowArms());
        nbt.m_128350_("Scale", this.getEntityScale());
        if (this.isMarker()) {
            nbt.m_128379_("Marker", this.isMarker());
        }
        this.getOwner().ifPresent(owner -> nbt.m_128362_("Owner", owner));
        nbt.m_128365_("Pose", (Tag)this.writePose());
        nbt.m_128344_("SkinParts", ((Byte)this.f_19804_.m_135370_(DATA_PLAYER_SKIN_CUSTOMISATION)).byteValue());
        ((Optional)this.f_19804_.m_135370_(DATA_PROFILE)).ifPresent(profile -> nbt.m_128365_("Profile", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)profile)));
        nbt.m_128365_("Rotations", (Tag)this.getEntityRotations().m_123155_());
        nbt.m_128379_("Invulnerable", this.m_20147_());
        ((Optional)this.f_19804_.m_135370_(DATA_ANIMATION)).ifPresent(animation -> nbt.m_128365_("Animation", (Tag)StatueAnimation.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, animation).getOrThrow(false, s -> {})));
        nbt.m_128405_("AnimationProgress", this.getAnimationProgress());
        nbt.m_128379_("AnimationReversing", this.isAnimationReversing());
        nbt.m_128379_("AnimationPlaying", this.isAnimationPlaying());
        nbt.m_128405_("Skin", this.getSkin());
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("ArmorItems", 9)) {
            ListTag listtag = nbt.m_128437_("ArmorItems", 10);
            for (int i = 0; i < this.armorItems.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                this.armorItems.set(i, (Object)ItemStack.m_41712_((CompoundTag)compoundtag));
            }
        }
        if (nbt.m_128425_("HandItems", 9)) {
            ListTag listtag1 = nbt.m_128437_("HandItems", 10);
            for (int j = 0; j < this.handItems.size(); ++j) {
                CompoundTag compoundtag2 = listtag1.m_128728_(j);
                this.handItems.set(j, (Object)ItemStack.m_41712_((CompoundTag)compoundtag2));
            }
        }
        this.m_6842_(nbt.m_128471_("Invisible"));
        this.setSmall(nbt.m_128471_("Small"));
        this.setShowArms(nbt.m_128471_("ShowArms"));
        this.setSlimArms(nbt.m_128471_("SlimArms"));
        this.setMarker(nbt.m_128471_("Marker"));
        this.setEntityScale(nbt.m_128457_("Scale"));
        Optional<Object> owner = Optional.empty();
        if (nbt.m_128441_("Owner")) {
            owner = Optional.of(nbt.m_128342_("Owner"));
        }
        this.setOwner(owner.orElse(null));
        this.f_19794_ = !this.hasPhysics();
        CompoundTag compoundtag1 = nbt.m_128469_("Pose");
        this.readPose(compoundtag1);
        this.f_19804_.m_135381_(DATA_PLAYER_SKIN_CUSTOMISATION, (Object)nbt.m_128445_("SkinParts"));
        Optional<Object> optional = Optional.empty();
        if (nbt.m_128425_("Profile", 10)) {
            optional = Optional.ofNullable(NbtUtils.m_129228_((CompoundTag)nbt.m_128469_("Profile")));
        }
        this.setProfile(optional.orElse(null));
        if (nbt.m_128425_("Rotations", 9)) {
            Rotations entityRotations = new Rotations(nbt.m_128437_("Rotations", 5));
            this.setEntityRotations(entityRotations.m_123156_(), entityRotations.m_123157_(), entityRotations.m_123158_());
            this.entityRotationsO = this.getEntityRotations();
        }
        if (nbt.m_128441_("Invulnerable")) {
            this.m_20331_(nbt.m_128471_("Invulnerable"));
        }
        Optional<Dynamic> animationOptional = Optional.empty();
        if (nbt.m_128425_("Animation", 10)) {
            animationOptional = Optional.of(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)nbt.m_128423_("Animation")));
        }
        if (animationOptional.isEmpty()) {
            this.setAnimation(null);
        } else {
            animationOptional.map(arg_0 -> StatueAnimation.CODEC.parse(arg_0)).flatMap(dataResult -> dataResult.resultOrPartial(System.out::println)).ifPresent(this::setAnimation);
        }
        this.setAnimationProgress(nbt.m_128451_("AnimationProgress"));
        this.setAnimationReversing(nbt.m_128471_("AnimationReversing"));
        this.setAnimationPlaying(nbt.m_128471_("AnimationPlaying"));
        this.setSkin(nbt.m_128451_("Skin"));
    }

    public void setSkin(int skin) {
        this.f_19804_.m_135381_(DATA_SKIN, (Object)skin);
    }

    public int getSkin() {
        return (Integer)this.f_19804_.m_135370_(DATA_SKIN);
    }

    public void setAnimation(StatueAnimation statueAnimation) {
        this.f_19804_.m_135381_(DATA_ANIMATION, Optional.ofNullable(statueAnimation));
    }

    public Optional<StatueAnimation> getAnimation() {
        return (Optional)this.f_19804_.m_135370_(DATA_ANIMATION);
    }

    public int getAnimationProgress() {
        return (Integer)this.f_19804_.m_135370_(DATA_ANIMATION_PROGRESS);
    }

    public void setAnimationProgress(int progress) {
        this.f_19804_.m_135381_(DATA_ANIMATION_PROGRESS, (Object)progress);
    }

    public boolean isAnimationReversing() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ANIMATION_REVERSING);
    }

    public void setAnimationReversing(boolean reversing) {
        this.f_19804_.m_135381_(DATA_ANIMATION_REVERSING, (Object)reversing);
    }

    public boolean isAnimationPlaying() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ANIMATION_PLAYING);
    }

    public void setAnimationPlaying(boolean playing) {
        this.f_19804_.m_135381_(DATA_ANIMATION_PLAYING, (Object)playing);
    }

    private void readPose(CompoundTag p_31658_) {
        ListTag listtag = p_31658_.m_128437_("Head", 5);
        this.setHeadPose(listtag.isEmpty() ? DEFAULT_HEAD_POSE : new Rotations(listtag));
        ListTag listtag1 = p_31658_.m_128437_("Body", 5);
        this.setBodyPose(listtag1.isEmpty() ? DEFAULT_BODY_POSE : new Rotations(listtag1));
        ListTag listtag2 = p_31658_.m_128437_("LeftArm", 5);
        this.setLeftArmPose(listtag2.isEmpty() ? DEFAULT_LEFT_ARM_POSE : new Rotations(listtag2));
        ListTag listtag3 = p_31658_.m_128437_("RightArm", 5);
        this.setRightArmPose(listtag3.isEmpty() ? DEFAULT_RIGHT_ARM_POSE : new Rotations(listtag3));
        ListTag listtag4 = p_31658_.m_128437_("LeftLeg", 5);
        this.setLeftLegPose(listtag4.isEmpty() ? DEFAULT_LEFT_LEG_POSE : new Rotations(listtag4));
        ListTag listtag5 = p_31658_.m_128437_("RightLeg", 5);
        this.setRightLegPose(listtag5.isEmpty() ? DEFAULT_RIGHT_LEG_POSE : new Rotations(listtag5));
    }

    private CompoundTag writePose() {
        CompoundTag compoundtag = new CompoundTag();
        if (!DEFAULT_HEAD_POSE.equals((Object)this.headPose)) {
            compoundtag.m_128365_("Head", (Tag)this.headPose.m_123155_());
        }
        if (!DEFAULT_BODY_POSE.equals((Object)this.bodyPose)) {
            compoundtag.m_128365_("Body", (Tag)this.bodyPose.m_123155_());
        }
        if (!DEFAULT_LEFT_ARM_POSE.equals((Object)this.leftArmPose)) {
            compoundtag.m_128365_("LeftArm", (Tag)this.leftArmPose.m_123155_());
        }
        if (!DEFAULT_RIGHT_ARM_POSE.equals((Object)this.rightArmPose)) {
            compoundtag.m_128365_("RightArm", (Tag)this.rightArmPose.m_123155_());
        }
        if (!DEFAULT_LEFT_LEG_POSE.equals((Object)this.leftLegPose)) {
            compoundtag.m_128365_("LeftLeg", (Tag)this.leftLegPose.m_123155_());
        }
        if (!DEFAULT_RIGHT_LEG_POSE.equals((Object)this.rightLegPose)) {
            compoundtag.m_128365_("RightLeg", (Tag)this.rightLegPose.m_123155_());
        }
        return compoundtag;
    }

    public float getEntityScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    public void setEntityScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity p_31564_) {
    }

    protected void m_6138_() {
        for (Entity entity : this.m_9236_().m_6249_((Entity)this, this.m_20191_(), RIDABLE_MINECARTS)) {
            if (!(this.m_20280_(entity) <= 0.2)) continue;
            entity.m_7334_((Entity)this);
        }
    }

    public InteractionResult m_7111_(Player player, Vec3 clickedPos, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isMarker() || itemstack.m_150930_(Items.f_42656_)) {
            return InteractionResult.PASS;
        }
        if (player.m_5833_()) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_9236_().f_46443_) {
            return InteractionResult.CONSUME;
        }
        if (this.m_20147_() && this.hasOwner() && !player.m_20148_().equals(this.getOwner().get()) && !player.m_7500_()) {
            player.m_5661_((Component)CreateQOLLang.translateDirect("statue.locked", new Object[0]).m_130940_(ChatFormatting.RED), true);
            return InteractionResult.FAIL;
        }
        if (player.m_21120_(hand).m_150930_(Items.f_42406_) && player.m_21120_(hand).m_41786_().getString().equals("OuiOuiBaguetteUwU")) {
            if (this.getSkin() == 0) {
                this.setSkin(1);
                return InteractionResult.SUCCESS;
            }
            if (this.getSkin() == 1) {
                this.setSkin(0);
                return InteractionResult.SUCCESS;
            }
        }
        if (player.m_21120_(hand).m_150930_(AllItems.WRENCH.m_5456_()) && this.getAnimation().isPresent()) {
            if (player.m_6047_()) {
                this.setAnimationProgress(0);
                this.setAnimationPlaying(true);
            } else {
                this.setAnimationPlaying(!this.isAnimationPlaying());
            }
            ScrollValueHandler.wrenchCog.bump(30.0);
        } else {
            EquipmentSlot slot;
            if (player.m_6047_()) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                    @NotNull
                    public Component m_5446_() {
                        return Statue.this.m_5446_();
                    }

                    @Nullable
                    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
                        return new StatueMenu(i, player.m_150109_(), Statue.this);
                    }
                }, buf -> buf.writeInt(this.m_19879_()));
                return InteractionResult.SUCCESS;
            }
            EquipmentSlot equipmentslot = Statue.m_147233_((ItemStack)itemstack);
            if (itemstack.m_41619_() ? this.swapItem(slot = this.getClickedSlot(clickedPos), ItemStack.f_41583_) : this.swapItem(equipmentslot, itemstack)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private boolean swapItem(EquipmentSlot slot, ItemStack stack) {
        ItemStack stackInSlot = this.m_6844_(slot);
        if (!stackInSlot.m_41619_()) {
            this.m_8061_(slot, stack);
            return true;
        }
        if (!stack.m_41619_()) {
            this.m_8061_(slot, stack.m_255036_(1));
            return true;
        }
        return false;
    }

    public void m_20331_(boolean invulnerable) {
        super.m_20331_(invulnerable);
        this.f_19804_.m_135381_(DATA_INVULNERABLE, (Object)invulnerable);
    }

    public boolean m_20147_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_INVULNERABLE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EquipmentSlot getClickedSlot(Vec3 p_31660_) {
        EquipmentSlot equipmentslot = EquipmentSlot.MAINHAND;
        boolean flag = this.isSmall();
        double d0 = p_31660_.f_82480_ / ((double)this.m_6134_() * (this.isSmall() ? 0.5 : 1.0));
        EquipmentSlot equipmentslot1 = EquipmentSlot.FEET;
        if (d0 >= 0.1) {
            double d = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d && this.m_21033_(equipmentslot1)) {
                return EquipmentSlot.FEET;
            }
        }
        double d = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d) {
            double d2 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d2 && this.m_21033_(EquipmentSlot.CHEST)) {
                return EquipmentSlot.CHEST;
            }
        }
        if (d0 >= 0.4) {
            double d3 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d3 && this.m_21033_(EquipmentSlot.LEGS)) {
                return EquipmentSlot.LEGS;
            }
        }
        if (d0 >= 1.6 && this.m_21033_(EquipmentSlot.HEAD)) {
            return EquipmentSlot.HEAD;
        }
        if (this.m_21033_(EquipmentSlot.MAINHAND)) return equipmentslot;
        if (!this.m_21033_(EquipmentSlot.OFFHAND)) return equipmentslot;
        return EquipmentSlot.OFFHAND;
    }

    public boolean m_6469_(DamageSource p_31579_, float p_31580_) {
        if (!this.m_9236_().f_46443_ && !this.m_213877_()) {
            ServerPlayer player;
            if (p_31579_.m_269533_(DamageTypeTags.f_268738_)) {
                this.m_6074_();
                return false;
            }
            Entity entity = p_31579_.m_7639_();
            if (entity instanceof ServerPlayer && !(player = (ServerPlayer)entity).m_7500_() && this.m_20147_() && this.hasOwner() && !this.getOwner().get().equals(player.m_20148_())) {
                return false;
            }
            if (!(this.m_6673_(p_31579_) || this.invisible || this.isMarker())) {
                Entity entity2;
                Player player2;
                if (p_31579_.m_269533_(DamageTypeTags.f_268415_)) {
                    this.brokenByAnything(p_31579_);
                    this.m_6074_();
                    return false;
                }
                if (p_31579_.m_269533_(DamageTypeTags.f_268727_)) {
                    if (this.m_6060_()) {
                        this.causeDamage(p_31579_, 0.15f);
                    } else {
                        this.m_20254_(5);
                    }
                    return false;
                }
                if (p_31579_.m_269533_(DamageTypeTags.f_268711_) && this.m_21223_() > 0.5f) {
                    this.causeDamage(p_31579_, 4.0f);
                    return false;
                }
                boolean flag = p_31579_.m_7640_() instanceof AbstractArrow;
                boolean flag1 = flag && ((AbstractArrow)p_31579_.m_7640_()).m_36796_() > 0;
                boolean flag2 = "player".equals(p_31579_.m_19385_());
                if (!flag2 && !flag) {
                    return false;
                }
                Entity entity3 = p_31579_.m_7639_();
                if (entity3 instanceof Player) {
                    player2 = (Player)entity3;
                    if (!player2.m_150110_().f_35938_) {
                        return false;
                    }
                }
                if ((entity2 = p_31579_.m_7639_()) instanceof Player && (player2 = (Player)entity2).m_21205_().m_150930_(AllItems.WRENCH.m_5456_())) {
                    this.playBrokenSound();
                    if (!p_31579_.m_19390_()) {
                        this.brokenByPlayer(p_31579_);
                    }
                    this.showBreakingParticles();
                    this.m_6074_();
                    return true;
                }
                if (p_31579_.m_19390_()) {
                    this.playBrokenSound();
                    this.showBreakingParticles();
                    this.m_6074_();
                    return flag1;
                }
                long i = this.m_9236_().m_46467_();
                if (i - this.lastHit > 5L && !flag) {
                    this.m_9236_().m_7605_((Entity)this, (byte)32);
                    this.m_146852_(GameEvent.f_223706_, p_31579_.m_7639_());
                    this.lastHit = i;
                } else {
                    this.brokenByPlayer(p_31579_);
                    this.showBreakingParticles();
                    this.m_6074_();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void m_7822_(byte p_31568_) {
        if (p_31568_ == 32) {
            if (this.m_9236_().f_46443_) {
                this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11683_, this.m_5720_(), 0.3f, 1.0f, false);
                this.lastHit = this.m_9236_().m_46467_();
            }
        } else {
            super.m_7822_(p_31568_);
        }
    }

    public boolean m_6783_(double p_31574_) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return p_31574_ < (d0 *= 64.0) * d0;
    }

    private void showBreakingParticles() {
        if (this.m_9236_() instanceof ServerLevel) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50705_.m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    private void causeDamage(DamageSource p_31649_, float p_31650_) {
        float f = this.m_21223_();
        if ((f -= p_31650_) <= 0.5f) {
            this.brokenByAnything(p_31649_);
            this.m_6074_();
        } else {
            this.m_21153_(f);
            this.m_146852_(GameEvent.f_223706_, p_31649_.m_7639_());
        }
    }

    private void brokenByPlayer(DamageSource p_31647_) {
        ItemStack itemstack = new ItemStack((ItemLike)QOLItems.STATUE.get());
        if (this.m_8077_()) {
            itemstack.m_41714_(this.m_7770_());
        }
        Block.m_49840_((Level)this.m_9236_(), (BlockPos)this.m_20183_(), (ItemStack)itemstack);
        this.brokenByAnything(p_31647_);
    }

    private void brokenByAnything(DamageSource p_31654_) {
        this.playBrokenSound();
        this.m_6668_(p_31654_);
    }

    private void playBrokenSound() {
        this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), AllSoundEvents.CARDBOARD_SWORD.getMainEvent(), this.m_5720_(), 1.0f, 0.5f);
    }

    protected float m_5632_(float p_31644_, float p_31645_) {
        this.f_20884_ = this.f_19859_;
        this.f_20883_ = this.m_146908_();
        return 0.0f;
    }

    public void m_7023_(Vec3 p_31656_) {
        if (this.hasPhysics()) {
            super.m_7023_(p_31656_);
        }
    }

    public void m_5618_(float p_31670_) {
        this.f_20884_ = this.f_19859_ = p_31670_;
        this.f_20886_ = this.f_20885_ = p_31670_;
    }

    public void m_5616_(float p_31668_) {
        this.f_20884_ = this.f_19859_ = p_31668_;
        this.f_20886_ = this.f_20885_ = p_31668_;
    }

    public void m_8119_() {
        Rotations rotations5;
        Rotations rotations4;
        Rotations rotations3;
        Rotations rotations2;
        Rotations rotations1;
        super.m_8119_();
        Rotations rotations = (Rotations)this.f_19804_.m_135370_(DATA_HEAD_POSE);
        if (!this.headPose.equals((Object)rotations)) {
            this.setHeadPose(rotations);
        }
        if (!this.bodyPose.equals((Object)(rotations1 = (Rotations)this.f_19804_.m_135370_(DATA_BODY_POSE)))) {
            this.setBodyPose(rotations1);
        }
        if (!this.leftArmPose.equals((Object)(rotations2 = (Rotations)this.f_19804_.m_135370_(DATA_LEFT_ARM_POSE)))) {
            this.setLeftArmPose(rotations2);
        }
        if (!this.rightArmPose.equals((Object)(rotations3 = (Rotations)this.f_19804_.m_135370_(DATA_RIGHT_ARM_POSE)))) {
            this.setRightArmPose(rotations3);
        }
        if (!this.leftLegPose.equals((Object)(rotations4 = (Rotations)this.f_19804_.m_135370_(DATA_LEFT_LEG_POSE)))) {
            this.setLeftLegPose(rotations4);
        }
        if (!this.rightLegPose.equals((Object)(rotations5 = (Rotations)this.f_19804_.m_135370_(DATA_RIGHT_LEG_POSE)))) {
            this.setRightLegPose(rotations5);
        }
        if (this.m_9236_().f_46443_) {
            return;
        }
        this.tickAnimation();
    }

    public void tickAnimation() {
        this.getAnimation().ifPresent(animation -> {
            if (this.isAnimationPlaying()) {
                if (this.getAnimationProgress() < animation.getDuration() && !this.isAnimationReversing()) {
                    this.setAnimationProgress(this.getAnimationProgress() + 1);
                } else if (this.getAnimationProgress() > 0 && this.isAnimationReversing()) {
                    this.setAnimationProgress(this.getAnimationProgress() - 1);
                } else if (this.getAnimationProgress() >= animation.getDuration()) {
                    if (animation.canBeRevert()) {
                        this.setAnimationReversing(true);
                    } else {
                        this.setAnimationProgress(animation.isLooping() ? 0 : this.getAnimationProgress());
                        this.setAnimationPlaying(animation.isLooping());
                    }
                } else if (this.getAnimationProgress() <= 0) {
                    this.setAnimationReversing(false);
                    this.setAnimationPlaying(animation.isLooping());
                }
                if (animation.getFrameForProgress(this.getAnimationProgress()) != null) {
                    StatueAnimationFrame frame = animation.getFrameForProgress(this.getAnimationProgress());
                    if (animation.getNextFrame(frame) == null) {
                        this.setEntityRotations(frame.getGlobal().getXRot(), frame.getGlobal().getYRot(), frame.getGlobal().getZRot());
                        this.setHeadPose(frame.getHead().toRotation());
                        this.setLeftArmPose(frame.getLeftArm().toRotation());
                        this.setRightArmPose(frame.getRightArm().toRotation());
                        this.setLeftLegPose(frame.getLeftLeg().toRotation());
                        this.setRightLegPose(frame.getRightLeg().toRotation());
                    } else {
                        StatueAnimationFrame nextFrame = animation.getNextFrame(frame);
                        float t = (float)(this.getAnimationProgress() - frame.getTick()) / (float)(animation.getNextFrame(frame).getTick() - frame.getTick());
                        Rotations globalPart = frame.getGlobal().toRotation();
                        Rotations nextGlobalPart = nextFrame.getGlobal().toRotation();
                        this.setEntityRotations(Mth.m_14179_((float)t, (float)globalPart.m_123156_(), (float)nextGlobalPart.m_123156_()), Mth.m_14179_((float)t, (float)globalPart.m_123157_(), (float)nextGlobalPart.m_123157_()), Mth.m_14179_((float)t, (float)globalPart.m_123158_(), (float)nextGlobalPart.m_123158_()));
                        Rotations headPart = frame.getHead().toRotation();
                        Rotations nextHeadPart = nextFrame.getHead().toRotation();
                        this.setHeadPose(new Rotations(Mth.m_14179_((float)t, (float)headPart.m_123156_(), (float)nextHeadPart.m_123156_()), Mth.m_14179_((float)t, (float)headPart.m_123157_(), (float)nextHeadPart.m_123157_()), Mth.m_14179_((float)t, (float)headPart.m_123158_(), (float)nextHeadPart.m_123158_())));
                        Rotations leftArmPart = frame.getLeftArm().toRotation();
                        Rotations nextLeftArmPart = nextFrame.getLeftArm().toRotation();
                        this.setLeftArmPose(new Rotations(Mth.m_14179_((float)t, (float)leftArmPart.m_123156_(), (float)nextLeftArmPart.m_123156_()), Mth.m_14179_((float)t, (float)leftArmPart.m_123157_(), (float)nextLeftArmPart.m_123157_()), Mth.m_14179_((float)t, (float)leftArmPart.m_123158_(), (float)nextLeftArmPart.m_123158_())));
                        Rotations rightArmPart = frame.getRightArm().toRotation();
                        Rotations nextRightArmPart = nextFrame.getRightArm().toRotation();
                        this.setRightArmPose(new Rotations(Mth.m_14179_((float)t, (float)rightArmPart.m_123156_(), (float)nextRightArmPart.m_123156_()), Mth.m_14179_((float)t, (float)rightArmPart.m_123157_(), (float)nextRightArmPart.m_123157_()), Mth.m_14179_((float)t, (float)rightArmPart.m_123158_(), (float)nextRightArmPart.m_123158_())));
                        Rotations leftLegPart = frame.getLeftLeg().toRotation();
                        Rotations nextLeftLegPart = nextFrame.getLeftLeg().toRotation();
                        this.setLeftLegPose(new Rotations(Mth.m_14179_((float)t, (float)leftLegPart.m_123156_(), (float)nextLeftLegPart.m_123156_()), Mth.m_14179_((float)t, (float)leftLegPart.m_123157_(), (float)nextLeftLegPart.m_123157_()), Mth.m_14179_((float)t, (float)leftLegPart.m_123158_(), (float)nextLeftLegPart.m_123158_())));
                        Rotations rightLegPart = frame.getRightLeg().toRotation();
                        Rotations nextRightLegPart = nextFrame.getRightLeg().toRotation();
                        this.setRightLegPose(new Rotations(Mth.m_14179_((float)t, (float)rightLegPart.m_123156_(), (float)nextRightLegPart.m_123156_()), Mth.m_14179_((float)t, (float)rightLegPart.m_123157_(), (float)nextRightLegPart.m_123157_()), Mth.m_14179_((float)t, (float)rightLegPart.m_123158_(), (float)nextRightLegPart.m_123158_())));
                    }
                }
            }
        });
    }

    protected void m_8034_() {
        this.m_6842_(this.invisible);
    }

    public void m_6842_(boolean p_31663_) {
        this.invisible = p_31663_;
        super.m_6842_(p_31663_);
    }

    public boolean m_6162_() {
        return this.isSmall();
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.m_146850_(GameEvent.f_223707_);
    }

    public boolean m_6128_() {
        return this.m_20145_() || this.m_20147_();
    }

    public PushReaction m_7752_() {
        return this.isMarker() ? PushReaction.IGNORE : super.m_7752_();
    }

    public boolean m_6090_() {
        return this.isMarker();
    }

    public void setSmall(boolean p_31604_) {
        this.f_19804_.m_135381_(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS), 1, p_31604_));
    }

    public boolean isSmall() {
        return ((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS) & 1) != 0;
    }

    public void setShowArms(boolean p_31676_) {
        this.f_19804_.m_135381_(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS), 4, p_31676_));
    }

    public boolean isShowArms() {
        return ((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS) & 4) != 0;
    }

    public void setSlimArms(boolean p_31676_) {
        this.f_19804_.m_135381_(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS), 8, p_31676_));
    }

    public boolean isSlimArms() {
        return ((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS) & 8) != 0;
    }

    public void setMarker(boolean p_31682_) {
        this.f_19804_.m_135381_(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS), 16, p_31682_));
    }

    public boolean isMarker() {
        return ((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS) & 0x10) != 0;
    }

    private byte setBit(byte value, int mask, boolean status) {
        value = status ? (byte)(value | mask) : (byte)(value & ~mask);
        return value;
    }

    public void setOwner(UUID owner) {
        this.f_19804_.m_135381_(DATA_OWNER, owner == null ? Optional.empty() : Optional.of(owner));
    }

    public boolean hasOwner() {
        return this.getOwner().isPresent();
    }

    public Optional<UUID> getOwner() {
        return (Optional)this.f_19804_.m_135370_(DATA_OWNER);
    }

    public void setHeadPose(Rotations p_31598_) {
        this.headPose = p_31598_;
        this.f_19804_.m_135381_(DATA_HEAD_POSE, (Object)p_31598_);
    }

    public void setBodyPose(Rotations p_31617_) {
        this.bodyPose = p_31617_;
        this.f_19804_.m_135381_(DATA_BODY_POSE, (Object)p_31617_);
    }

    public void setLeftArmPose(Rotations p_31624_) {
        this.leftArmPose = p_31624_;
        this.f_19804_.m_135381_(DATA_LEFT_ARM_POSE, (Object)p_31624_);
    }

    public void setRightArmPose(Rotations p_31629_) {
        this.rightArmPose = p_31629_;
        this.f_19804_.m_135381_(DATA_RIGHT_ARM_POSE, (Object)p_31629_);
    }

    public void setLeftLegPose(Rotations p_31640_) {
        this.leftLegPose = p_31640_;
        this.f_19804_.m_135381_(DATA_LEFT_LEG_POSE, (Object)p_31640_);
    }

    public void setRightLegPose(Rotations p_31652_) {
        this.rightLegPose = p_31652_;
        this.f_19804_.m_135381_(DATA_RIGHT_LEG_POSE, (Object)p_31652_);
    }

    public Rotations getHeadPose() {
        return this.headPose;
    }

    public Rotations getBodyPose() {
        return this.bodyPose;
    }

    public Rotations getLeftArmPose() {
        return this.leftArmPose;
    }

    public Rotations getRightArmPose() {
        return this.rightArmPose;
    }

    public Rotations getLeftLegPose() {
        return this.leftLegPose;
    }

    public Rotations getRightLegPose() {
        return this.rightLegPose;
    }

    public boolean m_6087_() {
        return super.m_6087_() && !this.isMarker();
    }

    public boolean m_7313_(Entity p_31687_) {
        return p_31687_ instanceof Player && !this.m_9236_().m_7966_((Player)p_31687_, this.m_20183_());
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(SoundEvents.f_11682_, SoundEvents.f_11682_);
    }

    @javax.annotation.Nullable
    protected SoundEvent m_7975_(DamageSource p_31636_) {
        return SoundEvents.f_11683_;
    }

    @javax.annotation.Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11681_;
    }

    public void m_8038_(ServerLevel p_31576_, LightningBolt p_31577_) {
    }

    public boolean m_5801_() {
        return false;
    }

    public void m_7350_(EntityDataAccessor<?> p_31602_) {
        if (DATA_CLIENT_FLAGS.equals(p_31602_)) {
            this.m_6210_();
            this.f_19850_ = !this.isMarker();
        }
        super.m_7350_(p_31602_);
    }

    public boolean m_5789_() {
        return false;
    }

    private EntityDimensions getDimensionsMarker(boolean p_31684_) {
        if (p_31684_) {
            return MARKER_DIMENSIONS;
        }
        return this.m_6162_() ? BABY_DIMENSIONS : this.m_6095_().m_20680_();
    }

    public boolean isPartShown(PlayerModelPart part) {
        return ((Byte)this.m_20088_().m_135370_(DATA_PLAYER_SKIN_CUSTOMISATION) & part.m_36445_()) == part.m_36445_();
    }

    public void setPartVisibility(PlayerModelPart modelPart, boolean visible) {
        this.f_19804_.m_135381_(DATA_PLAYER_SKIN_CUSTOMISATION, (Object)this.setBit((Byte)this.f_19804_.m_135370_(DATA_PLAYER_SKIN_CUSTOMISATION), modelPart.m_36445_(), visible));
    }

    public Vec3 m_7371_(float p_31665_) {
        if (this.isMarker()) {
            AABB aabb = this.getDimensionsMarker(false).m_20393_(this.m_20182_());
            BlockPos blockpos = this.m_20183_();
            int i = Integer.MIN_VALUE;
            for (BlockPos blockpos1 : BlockPos.m_121940_((BlockPos)BlockPos.m_274561_((double)aabb.f_82288_, (double)aabb.f_82289_, (double)aabb.f_82290_), (BlockPos)BlockPos.m_274561_((double)aabb.f_82291_, (double)aabb.f_82292_, (double)aabb.f_82293_))) {
                int j = Math.max(this.m_9236_().m_45517_(LightLayer.BLOCK, blockpos1), this.m_9236_().m_45517_(LightLayer.SKY, blockpos1));
                if (j == 15) {
                    return Vec3.m_82512_((Vec3i)blockpos1);
                }
                if (j <= i) continue;
                i = j;
                blockpos = blockpos1.m_7949_();
            }
            return Vec3.m_82512_((Vec3i)blockpos);
        }
        return super.m_7371_(p_31665_);
    }

    public Optional<GameProfile> getProfile() {
        return (Optional)this.f_19804_.m_135370_(DATA_PROFILE);
    }

    public void verifyAndSetProfile(@javax.annotation.Nullable GameProfile gameProfile) {
        if (!(gameProfile == null || gameProfile.isComplete() && gameProfile.getName().length() <= 16)) {
            if (gameProfile.getName().length() > 16) {
                if (gameProfile.getId() != null) {
                    gameProfile = new GameProfile(gameProfile.getId(), "");
                } else {
                    this.setOwner(null);
                    return;
                }
            }
            SkullBlockEntity.m_155738_((GameProfile)gameProfile, this::setProfile);
        } else {
            this.setProfile(gameProfile);
        }
    }

    public void setProfile(@javax.annotation.Nullable GameProfile resolvableProfile) {
        this.f_19804_.m_135381_(DATA_PROFILE, Optional.ofNullable(resolvableProfile));
    }

    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)QOLItems.STATUE.get());
    }

    public boolean m_142065_() {
        return !this.m_20145_() && !this.isMarker();
    }

    public static EntityType.Builder<?> build(EntityType.Builder<?> builder) {
        EntityType.Builder<?> entityBuilder = builder;
        return entityBuilder.m_20699_(0.5f, 1.975f);
    }

    public float getEntityXRotation() {
        return this.getEntityRotations().m_123156_();
    }

    public Rotations getEntityRotations() {
        Rotations rotations = (Rotations)this.f_19804_.m_135370_(DATA_GLOBAL_ROTATIONS);
        return new Rotations(rotations.m_123156_() - 180.0f, rotations.m_123157_() - 180.0f, rotations.m_123158_() - 180.0f);
    }

    public float getEntityZRotation() {
        return this.getEntityRotations().m_123158_();
    }

    public void setEntityXRotation(float rotationX) {
        this.setEntityRotations(rotationX, this.m_146908_(), this.getEntityZRotation());
    }

    public void setEntityZRotation(float rotationZ) {
        this.setEntityRotations(this.getEntityXRotation(), this.m_146908_(), rotationZ);
    }

    public void setEntityRotations(float rotationX, float rotationY, float rotationZ) {
        rotationX = Mth.m_14036_((float)(rotationX + 180.0f), (float)0.0f, (float)360.0f);
        rotationY = Mth.m_14036_((float)(rotationY + 180.0f), (float)0.0f, (float)360.0f);
        rotationZ = Mth.m_14036_((float)(rotationZ + 180.0f), (float)0.0f, (float)360.0f);
        this.f_19804_.m_135381_(DATA_GLOBAL_ROTATIONS, (Object)new Rotations(rotationX, rotationY, rotationZ));
    }

    public float m_146908_() {
        return this.getEntityRotations().m_123157_();
    }

    public void m_146922_(float p_146923_) {
        this.setEntityRotations(this.getEntityXRotation(), p_146923_, this.getEntityZRotation());
    }
}

