/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.statue.animation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.iglee42.createqualityoflife.packets.SyncAnimationsConfigPacket;
import fr.iglee42.createqualityoflife.registries.QOLPackets;
import fr.iglee42.createqualityoflife.statue.animation.StatueAnimation;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class PublishedAnimationsManager
extends SavedData {
    public static List<PublishedAnimation> CLIENT_ANIMATIONS = new ArrayList<PublishedAnimation>();
    private final List<PublishedAnimation> animations = new ArrayList<PublishedAnimation>();

    public PublishedAnimationsManager() {
    }

    public void loadFromBuffer(FriendlyByteBuf buf) {
        this.animations.clear();
        this.animations.addAll(PublishedAnimation.decodeList(buf));
    }

    public void writeToBuffer(FriendlyByteBuf buf) {
        PublishedAnimation.encodeList(buf, this.animations);
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        this.animations.forEach(a -> list.add((Object)((Tag)PublishedAnimation.CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, a).getOrThrow(false, s -> {}))));
        tag.m_128365_("animations", (Tag)list);
        return tag;
    }

    public PublishedAnimationsManager(CompoundTag tag) {
        ListTag list = tag.m_128437_("animations", 10);
        list.stream().map(CompoundTag.class::cast).forEach(ct -> this.animations.add((PublishedAnimation)PublishedAnimation.CODEC.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, ct)).getOrThrow(false, s -> {})));
        this.m_77762_();
    }

    @Nonnull
    public static PublishedAnimationsManager get(Level level) {
        if (level.f_46443_) {
            throw new RuntimeException("You can't access to client side!");
        }
        DimensionDataStorage storage = ((ServerLevel)level).m_8895_();
        return (PublishedAnimationsManager)storage.m_164861_(PublishedAnimationsManager::new, PublishedAnimationsManager::new, "createqol_published_animations");
    }

    public void publishAnimation(UUID publisher, String name, StatueAnimation animation) {
        this.animations.add(new PublishedAnimation(publisher, UUID.randomUUID(), name, animation));
        this.m_77762_();
    }

    public void tick(ServerLevel level) {
        if (this.m_77764_()) {
            level.m_6907_().forEach(sp -> QOLPackets.sendToPlayer(sp, new SyncAnimationsConfigPacket(this.animations)));
        }
    }

    public void deleteAnimation(UUID animation) {
        this.animations.removeIf(a -> a.id().equals(animation));
        this.m_77762_();
    }

    public record PublishedAnimation(UUID publisher, UUID id, String name, StatueAnimation animation) {
        public static final Codec<PublishedAnimation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.f_235867_.fieldOf("publisher").forGetter(PublishedAnimation::publisher), (App)UUIDUtil.f_235867_.fieldOf("id").forGetter(PublishedAnimation::id), (App)Codec.STRING.fieldOf("name").forGetter(PublishedAnimation::name), (App)StatueAnimation.CODEC.fieldOf("animation").forGetter(PublishedAnimation::animation)).apply((Applicative)instance, PublishedAnimation::new));

        public static void encode(FriendlyByteBuf buf, PublishedAnimation anim) {
            buf.m_130077_(anim.publisher);
            buf.m_130077_(anim.id);
            buf.m_130070_(anim.name);
            StatueAnimation.encode(buf, anim.animation);
        }

        public static PublishedAnimation decode(FriendlyByteBuf buf) {
            UUID publisher = buf.m_130259_();
            UUID id = buf.m_130259_();
            String name = buf.m_130277_();
            StatueAnimation animation = StatueAnimation.decode(buf);
            return new PublishedAnimation(publisher, id, name, animation);
        }

        public static void encodeList(FriendlyByteBuf buf, List<PublishedAnimation> list) {
            buf.writeInt(list.size());
            for (PublishedAnimation anim : list) {
                PublishedAnimation.encode(buf, anim);
            }
        }

        public static List<PublishedAnimation> decodeList(FriendlyByteBuf buf) {
            int size = buf.readInt();
            ArrayList<PublishedAnimation> list = new ArrayList<PublishedAnimation>(size);
            for (int i = 0; i < size; ++i) {
                list.add(PublishedAnimation.decode(buf));
            }
            return list;
        }
    }
}

