/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.utils;

import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.config.CreateQOLConfigs;
import fr.iglee42.createqualityoflife.utils.IEnderLinkable;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.levelWrappers.WorldHelper;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;

public class EnderPackagersNetworkHandler {
    static final Map<LevelAccessor, Map<Couple<Frequency>, Set<IEnderLinkable>>> connections = new IdentityHashMap<LevelAccessor, Map<Couple<Frequency>, Set<IEnderLinkable>>>();
    public final AtomicInteger globalPowerVersion = new AtomicInteger();

    public void onLoadWorld(LevelAccessor world) {
        connections.put(world, new HashMap());
        CreateQOL.LOGGER.debug("Prepared Ender Packager Network Space for " + String.valueOf(WorldHelper.getDimensionID((LevelAccessor)world)));
    }

    public void onUnloadWorld(LevelAccessor world) {
        connections.remove(world);
        CreateQOL.LOGGER.debug("Removed Ender Packager Network Space for " + String.valueOf(WorldHelper.getDimensionID((LevelAccessor)world)));
    }

    public Set<IEnderLinkable> getNetworkOf(LevelAccessor world, IEnderLinkable actor) {
        Couple<Frequency> key;
        Map<Couple<Frequency>, Set<IEnderLinkable>> networksInWorld = this.networksIn(world);
        if (!networksInWorld.containsKey(key = actor.getNetworkKey())) {
            networksInWorld.put(key, new LinkedHashSet());
        }
        return networksInWorld.get(key);
    }

    public void addToNetwork(LevelAccessor world, IEnderLinkable actor) {
        this.getNetworkOf(world, actor).add(actor);
    }

    public void removeFromNetwork(LevelAccessor world, IEnderLinkable actor) {
        Set<IEnderLinkable> network = this.getNetworkOf(world, actor);
        network.remove(actor);
        if (network.isEmpty()) {
            this.networksIn(world).remove(actor.getNetworkKey());
        }
    }

    public boolean canSend(LevelAccessor world, IEnderLinkable actor, ItemStack packageItem) {
        Set<IEnderLinkable> network = this.getNetworkOf(world, actor);
        for (IEnderLinkable other : network) {
            if (other == actor || !other.isListening() || !EnderPackagersNetworkHandler.withinRange(actor, other) || !other.canAcceptPackage(packageItem)) continue;
            return true;
        }
        return false;
    }

    public void sendPackage(LevelAccessor world, IEnderLinkable actor, ItemStack packageItem) {
        Set<IEnderLinkable> network = this.getNetworkOf(world, actor);
        for (IEnderLinkable other : network) {
            if (other == actor || !other.isListening() || !EnderPackagersNetworkHandler.withinRange(actor, other) || !other.canAcceptPackage(packageItem)) continue;
            other.setReceivedPackage(packageItem);
            break;
        }
    }

    public static boolean withinRange(IEnderLinkable from, IEnderLinkable to) {
        if (from == to) {
            return true;
        }
        return from.getLocation().m_123314_((Vec3i)to.getLocation(), (double)((Integer)CreateQOLConfigs.server().logistics.enderLinkRange.get()).intValue());
    }

    public Map<Couple<Frequency>, Set<IEnderLinkable>> networksIn(LevelAccessor world) {
        if (!connections.containsKey(world)) {
            CreateQOL.LOGGER.warn("Tried to Access unprepared network space of " + String.valueOf(WorldHelper.getDimensionID((LevelAccessor)world)));
            return new HashMap<Couple<Frequency>, Set<IEnderLinkable>>();
        }
        return connections.get(world);
    }

    public static class Frequency {
        public static final Frequency EMPTY = new Frequency(ItemStack.f_41583_);
        private static final Map<Item, Frequency> simpleFrequencies = new IdentityHashMap<Item, Frequency>();
        private ItemStack stack;
        private Item item;
        private int color;

        public static Frequency of(ItemStack stack) {
            if (stack.m_41619_()) {
                return EMPTY;
            }
            if (!stack.m_41782_()) {
                return simpleFrequencies.computeIfAbsent(stack.m_41720_(), $ -> new Frequency(stack));
            }
            return new Frequency(stack);
        }

        private Frequency(ItemStack stack) {
            this.stack = stack;
            this.item = stack.m_41720_();
            CompoundTag displayTag = stack.m_41737_("display");
            this.color = displayTag != null && displayTag.m_128441_("color") ? displayTag.m_128451_("color") : -1;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public int hashCode() {
            return this.item.hashCode() * 31 ^ this.color;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof Frequency ? ((Frequency)obj).item == this.item && ((Frequency)obj).color == this.color : false;
        }
    }
}

