/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createqualityoflife.utils.liquidblazeburners;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.iglee42.createqualityoflife.CreateQOL;
import fr.iglee42.createqualityoflife.utils.liquidblazeburners.LiquidBlazeBurnerManager;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.registries.ForgeRegistries;

public class LiquidBlazeBurnerReloadListener
extends SimpleJsonResourceReloadListener {
    public static final String FLUID_KEY = "fluid";
    public static final String BURN_TIME_KEY = "burnTime";
    public static final int DEFAULT_BURN_TIME = 20;
    public static final String SUPER_HEATED_KEY = "superHeat";
    public static final String CONSUMPTION_KEY = "consumptionPerTick";
    public static final int DEFAULT_CONSUMPTION = 1;
    ICondition.IContext context;
    public static final LiquidBlazeBurnerReloadListener INSTANCE = new LiquidBlazeBurnerReloadListener();

    public LiquidBlazeBurnerReloadListener() {
        this(ICondition.IContext.EMPTY);
    }

    public LiquidBlazeBurnerReloadListener(ICondition.IContext context) {
        super(new Gson(), "blaze_burner_liquids");
        this.context = context;
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager manager, ProfilerFiller filler) {
        LiquidBlazeBurnerManager.BLAZE_BURNER_LIQUIDS.clear();
        CreateQOL.LOGGER.info("Reloading Liquids for Blaze Burner...");
        jsons.forEach((rs, el) -> {
            try {
                int consumption;
                int burnTime;
                if (!el.isJsonObject()) {
                    throw new RuntimeException(rs.m_135815_() + " doesn't contain a json object as root");
                }
                JsonObject json = el.getAsJsonObject();
                if (!CraftingHelper.processConditions((JsonObject)json, (String)"conditions", (ICondition.IContext)this.context)) {
                    CreateQOL.LOGGER.debug("Skipping loading blaze burner liquid {} as its conditions were not met", rs);
                    return;
                }
                if (!json.has(FLUID_KEY)) {
                    throw new JsonParseException("Missing fluid key");
                }
                String fluid = json.get(FLUID_KEY).getAsString();
                if (!ForgeRegistries.FLUIDS.containsKey(ResourceLocation.m_135820_((String)fluid))) {
                    throw new JsonParseException(fluid + " is invalid in blaze burner liquid " + rs.toString());
                }
                int n = burnTime = json.has(BURN_TIME_KEY) ? json.get(BURN_TIME_KEY).getAsInt() : 20;
                if (burnTime < 1) {
                    throw new JsonParseException("Burn time must be at least 1 in " + rs.toString());
                }
                boolean superHeat = json.has(SUPER_HEATED_KEY) && json.get(SUPER_HEATED_KEY).getAsBoolean();
                int n2 = consumption = json.has(CONSUMPTION_KEY) ? json.get(CONSUMPTION_KEY).getAsInt() : 1;
                if (consumption < 0) {
                    throw new JsonParseException("Consumption can't be negative in " + rs.toString());
                }
                new Entry((Fluid)ForgeRegistries.FLUIDS.getValue(ResourceLocation.m_135820_((String)fluid)), burnTime, superHeat, consumption).registerToMap();
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                CreateQOL.LOGGER.error("Parsing error loading blaze burner liquid {}", rs, (Object)exception);
            }
        });
        CreateQOL.LOGGER.info("Liquids for Blaze Burner Reloaded, found {} liquids.", (Object)LiquidBlazeBurnerManager.BLAZE_BURNER_LIQUIDS.size());
    }

    private record Entry(Fluid fluid, int burnTime, boolean superHeat, int consumption) {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257020_.m_194605_().fieldOf(LiquidBlazeBurnerReloadListener.FLUID_KEY).forGetter(Entry::fluid), (App)Codec.INT.optionalFieldOf(LiquidBlazeBurnerReloadListener.BURN_TIME_KEY, (Object)20).forGetter(Entry::burnTime), (App)Codec.BOOL.optionalFieldOf(LiquidBlazeBurnerReloadListener.SUPER_HEATED_KEY, (Object)false).forGetter(Entry::superHeat), (App)Codec.INT.optionalFieldOf(LiquidBlazeBurnerReloadListener.CONSUMPTION_KEY, (Object)1).forGetter(Entry::consumption)).apply((Applicative)instance, Entry::new));

        public void registerToMap() throws IllegalArgumentException {
            if (LiquidBlazeBurnerManager.BLAZE_BURNER_LIQUIDS.containsKey(this.fluid)) {
                throw new IllegalArgumentException("Fluid " + String.valueOf(this.fluid) + " is registered for blaze burners in two different files");
            }
            LiquidBlazeBurnerManager.BLAZE_BURNER_LIQUIDS.put(this.fluid, new LiquidBlazeBurnerManager.LiquidEntry(this.burnTime, this.superHeat, this.consumption));
        }
    }
}

