/*
 * Decompiled with CFR 0.152.
 */
package com.github.liamsh.BetterArmedBedwars.sound;

import com.github.liamsh.BetterArmedBedwars.utils.GunUtil;
import com.github.liamsh.BetterArmedBedwars.utils.PlayerProximity;
import com.github.liamsh.BetterArmedBedwars.utils.ServerData;
import java.lang.reflect.Constructor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.sound.SoundEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class SoundEventHandler {
    private ItemStack lastGun = null;

    public static void playSound(String resourceName, float x, float y, float z) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147675_a((ResourceLocation)new ResourceLocation(resourceName), (float)x, (float)y, (float)z));
    }

    public static void playSound(String resourceName) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147673_a((ResourceLocation)new ResourceLocation(resourceName)));
    }

    public static void playSound(String resourceName, float volume, float x, float y, float z) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(new ResourceLocation(resourceName), volume, 1.0f, x, y, z));
    }

    public static void relocateSound(String resourceName, ISound sound) {
        try {
            Constructor constructor = PositionedSoundRecord.class.getDeclaredConstructor(ResourceLocation.class, Float.TYPE, Float.TYPE, Boolean.TYPE, Integer.TYPE, ISound.AttenuationType.class, Float.TYPE, Float.TYPE, Float.TYPE);
            constructor.setAccessible(true);
            ISound newSound = (ISound)constructor.newInstance(new ResourceLocation(resourceName), Float.valueOf(sound.func_147653_e()), Float.valueOf(sound.func_147655_f()), sound.func_147657_c(), sound.func_147652_d(), sound.func_147656_j(), Float.valueOf(sound.func_147649_g()), Float.valueOf(sound.func_147654_h()), Float.valueOf(sound.func_147651_i()));
            Minecraft.func_71410_x().func_147118_V().func_147682_a(newSound);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isBlockChord(float value) {
        return SoundEventHandler.endsWith(value, 0.5f);
    }

    public static boolean endsWith(float a, float b) {
        float decimalPart = Math.abs(a) - (float)Math.abs((int)a);
        return Float.compare(decimalPart, b) == 0;
    }

    public boolean handleSound(SoundEvent.SoundSourceEvent event) {
        ISound sound = event.sound;
        String name = event.name;
        if (ServerData.notInArmed()) {
            switch (name) {
                case "mob.irongolem.hit": 
                case "fireworks.blast": 
                case "fireworks.blast_far": 
                case "fireworks.largeBlast": 
                case "random.explode": 
                case "fire.fire": 
                case "mob.horse.gallop": 
                case "random.successful_hit": 
                case "tile.piston.in": 
                case "random.orb": {
                    return false;
                }
            }
            return true;
        }
        float pitch = sound.func_147655_f();
        float vol = sound.func_147653_e();
        float x = sound.func_147649_g();
        float y = sound.func_147654_h();
        float z = sound.func_147651_i();
        switch (name) {
            case "mob.irongolem.hit": {
                if (pitch < 2.49f) {
                    return false;
                }
                EntityPlayer closestPlayer = PlayerProximity.getClosestPlayer((World)Minecraft.func_71410_x().field_71441_e, x, y, z);
                if (closestPlayer == Minecraft.func_71410_x().field_71439_g) {
                    if (this.lastGun.func_77973_b().getRegistryName().equals("minecraft:wooden_hoe")) {
                        SoundEventHandler.playSound("guns.pistol.shot", vol, x, y, z);
                        return true;
                    }
                    SoundEventHandler.playSound("guns.magnum.shot", vol, x, y, z);
                    return true;
                }
                ItemStack itemStack = closestPlayer.func_70694_bm();
                if (itemStack == null) {
                    SoundEventHandler.playSound("guns.pistol.shot", vol, x, y, z);
                    return true;
                }
                Item item = itemStack.func_77973_b();
                if (item == null) {
                    SoundEventHandler.playSound("guns.pistol.shot", vol, x, y, z);
                    return true;
                }
                if (item.getRegistryName().equals("minecraft:wooden_hoe")) {
                    SoundEventHandler.playSound("guns.pistol.shot", vol, x, y, z);
                    return true;
                }
                SoundEventHandler.playSound("guns.magnum.shot", vol, x, y, z);
                return true;
            }
            case "fireworks.blast": {
                if (pitch < 2.49f) {
                    return false;
                }
                SoundEventHandler.playSound("guns.smg.shot", vol, x, y, z);
                return true;
            }
            case "fireworks.blast_far": {
                if (pitch < 2.49f) {
                    return false;
                }
                SoundEventHandler.playSound("guns.smg.shot", 0.5f, x, y, z);
                return true;
            }
            case "fireworks.largeBlast": {
                if (pitch > 2.49f) {
                    SoundEventHandler.playSound("guns.rifle.shot", x, y, z);
                    return true;
                }
                if ((double)pitch < 0.794) {
                    SoundEventHandler.playSound("guns.magnum.shot", x, y, z);
                    return true;
                }
                return false;
            }
            case "random.explode": {
                if (pitch < 2.49f) {
                    return false;
                }
                SoundEventHandler.playSound("guns.shotgun.shot", vol, x, y, z);
                return true;
            }
            case "fire.fire": {
                if (SoundEventHandler.isBlockChord(x) && SoundEventHandler.isBlockChord(y) && SoundEventHandler.isBlockChord(z)) {
                    return false;
                }
                if (SoundEventHandler.endsWith(x, 0.0f) && SoundEventHandler.endsWith(y, 0.5625f) && SoundEventHandler.endsWith(z, 0.0f)) {
                    return false;
                }
                SoundEventHandler.playSound("guns.flamethrower.shot", vol, x, y, z);
                return true;
            }
            case "mob.horse.gallop": {
                switch (this.lastGun.func_77973_b().getRegistryName()) {
                    case "minecraft:wooden_hoe": {
                        SoundEventHandler.playSound("guns.pistol.reload");
                        break;
                    }
                    case "minecraft:golden_hoe": {
                        SoundEventHandler.playSound("guns.magnum.reload");
                        break;
                    }
                    case "minecraft:stone_hoe": {
                        SoundEventHandler.playSound("guns.rifle.reload");
                        break;
                    }
                    case "minecraft:iron_hoe": {
                        SoundEventHandler.playSound("guns.shotgun.reload");
                        break;
                    }
                    case "minecraft:diamond_hoe": {
                        SoundEventHandler.playSound("guns.smg.reload");
                        break;
                    }
                    case "minecraft:flint_and_steel": {
                        SoundEventHandler.playSound("guns.flamethrower.reload");
                    }
                }
                return true;
            }
            case "random.successful_hit": {
                if (pitch != 2.0f && pitch != 1.4920635f) {
                    return false;
                }
                SoundEventHandler.playSound("bullet.hit", vol, x, y, z);
                return true;
            }
            case "tile.piston.in": {
                SoundEventHandler.playSound("bullet.whizz", vol, x, y, z);
                return true;
            }
            case "random.orb": {
                EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                if (player.field_70725_aQ > 0) {
                    return false;
                }
                if (player.func_110143_aJ() <= 0.0f) {
                    return false;
                }
                SoundEventHandler.playSound("bullet.kill");
                return true;
            }
        }
        return true;
    }

    @SubscribeEvent
    public void onSoundPlaying(SoundEvent.SoundSourceEvent event) {
        boolean soundPlayed = this.handleSound(event);
        if (soundPlayed) {
            return;
        }
        SoundEventHandler.relocateSound("default." + event.name, event.sound);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        ItemStack currentHeldItem = player.func_70694_bm();
        if (currentHeldItem == null) {
            return;
        }
        if (GunUtil.isGun(currentHeldItem.func_77973_b())) {
            this.lastGun = currentHeldItem;
        }
    }
}

