/*
 * Decompiled with CFR 0.152.
 */
package com.github.liamsh.BetterArmedBedwars.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C01PacketChatMessage;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ServerData {
    public static String gameType = null;
    private static boolean waitingForLocRaw = false;
    private static final boolean DEBUG = false;

    public static NBTTagCompound getNBT() {
        net.minecraft.client.multiplayer.ServerData serverData = Minecraft.func_71410_x().func_147104_D();
        if (serverData == null) {
            return null;
        }
        return serverData.func_78836_a();
    }

    public static void printNBT() {
        NBTTagCompound nbtTagCompound = ServerData.getNBT();
        if (nbtTagCompound == null) {
            System.out.println("Not connected to a server.");
            return;
        }
        String jsonString = nbtTagCompound.toString();
        System.out.println("NBT Data in JSON format: ");
        System.out.println(jsonString);
    }

    public static void printStats() {
        net.minecraft.client.multiplayer.ServerData serverData = Minecraft.func_71410_x().func_147104_D();
        if (serverData == null) {
            System.out.println("Not connected to a server.");
            return;
        }
        System.out.println("popInfo" + serverData.field_78846_c);
    }

    public static boolean isNBT(String tag, String value) {
        NBTTagCompound nbtTagCompound = ServerData.getNBT();
        if (nbtTagCompound == null) {
            return false;
        }
        return nbtTagCompound.func_74779_i(tag).equals(value);
    }

    public static String getNBT(String tag) {
        NBTTagCompound nbtTagCompound = ServerData.getNBT();
        if (nbtTagCompound == null) {
            return null;
        }
        return nbtTagCompound.func_74779_i(tag);
    }

    public static boolean inGame(String mode) {
        if (gameType == null) {
            return false;
        }
        return gameType.toUpperCase().endsWith(mode.toUpperCase());
    }

    public static boolean notInArmed() {
        if (gameType == null) {
            return true;
        }
        switch (gameType) {
            case "BEDWARS_EIGHT_TWO_ARMED": 
            case "BEDWARS_FOUR_FOUR_ARMED": {
                return false;
            }
        }
        return true;
    }

    @SubscribeEvent
    public void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.entity == null) {
            return;
        }
        if (event.entity != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        gameType = null;
        if (!event.world.field_72995_K) {
            return;
        }
        if (Minecraft.func_71410_x().func_147104_D() == null) {
            return;
        }
        String serverIP = Minecraft.func_71410_x().func_147104_D().field_78845_b;
        if (serverIP == null) {
            return;
        }
        if (!serverIP.toLowerCase().contains("hypixel.net")) {
            return;
        }
        if (waitingForLocRaw) {
            return;
        }
        waitingForLocRaw = true;
        Minecraft.func_71410_x().func_147114_u().func_147298_b().func_179290_a((Packet)new C01PacketChatMessage("/locraw"));
    }

    @SubscribeEvent
    public void onClientChatReceived(ClientChatReceivedEvent event) {
        if (!waitingForLocRaw) {
            return;
        }
        if (event.message == null) {
            return;
        }
        String message = event.message.func_150260_c();
        if (message == null) {
            return;
        }
        if (!message.startsWith("{") || !message.endsWith("}")) {
            return;
        }
        try {
            String mode;
            JsonObject locrawData = new JsonParser().parse(message).getAsJsonObject();
            gameType = mode = locrawData.get("gametype").getAsString();
            event.setCanceled(true);
            waitingForLocRaw = false;
            gameType = mode = locrawData.get("mode").getAsString();
        }
        catch (JsonSyntaxException jsonSyntaxException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

