/*
 * Decompiled with CFR 0.152.
 */
package com.nottouchedgrass.inventorystorages;

import com.mojang.logging.LogUtils;
import com.nottouchedgrass.inventorystorages.RegisterPayloads;
import com.nottouchedgrass.inventorystorages.blockentities.PlayerInventoryStorageBlockEntity;
import com.nottouchedgrass.inventorystorages.blockentities.PlayerSlotStorageBlockEntity;
import com.nottouchedgrass.inventorystorages.blocks.PlayerInventoryStorageBlock;
import com.nottouchedgrass.inventorystorages.blocks.PlayerSlotStorageBlock;
import com.nottouchedgrass.inventorystorages.menus.PlayerInventoryStorageMenu;
import com.nottouchedgrass.inventorystorages.menus.PlayerSlotStorageMenu;
import com.nottouchedgrass.inventorystorages.screens.PlayerInventoryStorageScreen;
import com.nottouchedgrass.inventorystorages.screens.PlayerSlotStorageScreen;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="inventorystorages")
public class InventoryStorages {
    public static final String MODID = "inventorystorages";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"inventorystorages");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"inventorystorages");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"inventorystorages");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"inventorystorages");
    public static final DeferredBlock<Block> PLAYER_INVENTORY_STORAGE = BLOCKS.registerBlock("player_inventory_storage", PlayerInventoryStorageBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE));
    public static final DeferredItem<BlockItem> PLAYER_INVENTORY_STORAGE_ITEM = ITEMS.registerSimpleBlockItem("player_inventory_storage", PLAYER_INVENTORY_STORAGE);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<PlayerInventoryStorageBlockEntity>> PLAYER_INVENTORY_STORAGE_BLOCK_ENTITY = BLOCK_ENTITIES.register("player_inventory_storage", () -> BlockEntityType.Builder.of(PlayerInventoryStorageBlockEntity::new, (Block[])new Block[]{(Block)PLAYER_INVENTORY_STORAGE.get()}).build(null));
    public static final DeferredHolder<MenuType<?>, MenuType<PlayerInventoryStorageMenu>> PLAYER_INVENTORY_STORAGE_MENU_TYPE = MENU_TYPES.register("player_inventory_storage", () -> IMenuTypeExtension.create(PlayerInventoryStorageMenu::new));
    public static final DeferredBlock<Block> PLAYER_SLOT_STORAGE = BLOCKS.registerBlock("player_slot_storage", PlayerSlotStorageBlock::new, BlockBehaviour.Properties.of().mapColor(MapColor.STONE));
    public static final DeferredItem<BlockItem> PLAYER_SLOT_STORAGE_ITEM = ITEMS.registerSimpleBlockItem("player_slot_storage", PLAYER_SLOT_STORAGE);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<PlayerSlotStorageBlockEntity>> PLAYER_SLOT_STORAGE_BLOCK_ENTITY = BLOCK_ENTITIES.register("player_slot_storage", () -> BlockEntityType.Builder.of(PlayerSlotStorageBlockEntity::new, (Block[])new Block[]{(Block)PLAYER_SLOT_STORAGE.get()}).build(null));
    public static final DeferredHolder<MenuType<?>, MenuType<PlayerSlotStorageMenu>> PLAYER_SLOT_STORAGE_MENU_TYPE = MENU_TYPES.register("player_slot_storage", () -> IMenuTypeExtension.create(PlayerSlotStorageMenu::new));

    public InventoryStorages(IEventBus modEventBus, ModContainer modContainer) {
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        MENU_TYPES.register(modEventBus);
        modEventBus.addListener(this::registerScreens);
        modEventBus.addListener(RegisterPayloads::register);
        modEventBus.addListener(this::modifyCreativeTabs);
    }

    private void registerScreens(RegisterMenuScreensEvent event) {
        event.register((MenuType)PLAYER_INVENTORY_STORAGE_MENU_TYPE.get(), PlayerInventoryStorageScreen::new);
        event.register((MenuType)PLAYER_SLOT_STORAGE_MENU_TYPE.get(), PlayerSlotStorageScreen::new);
    }

    public void modifyCreativeTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FUNCTIONAL_BLOCKS) {
            event.accept((ItemLike)PLAYER_SLOT_STORAGE_ITEM.get());
            event.accept((ItemLike)PLAYER_INVENTORY_STORAGE_ITEM.get());
        }
    }
}

