/*
 * Decompiled with CFR 0.152.
 */
package com.nottouchedgrass.inventorystorages;

import com.nottouchedgrass.inventorystorages.blockentities.PlayerInventoryStorageBlockEntity;
import com.nottouchedgrass.inventorystorages.blockentities.PlayerSlotStorageBlockEntity;
import com.nottouchedgrass.inventorystorages.blocks.PlayerInventoryStorageBlock;
import com.nottouchedgrass.inventorystorages.blocks.PlayerSlotStorageBlock;
import com.nottouchedgrass.inventorystorages.containers.UniversalInventory;
import com.nottouchedgrass.inventorystorages.menus.PlayerSlotStorageMenu;
import com.nottouchedgrass.inventorystorages.payloads.C2SSetOwner;
import com.nottouchedgrass.inventorystorages.payloads.C2SSetSlotId;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class RegisterPayloads {
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(C2SSetOwner.TYPE, C2SSetOwner.STREAM_CODEC, (payload, iPayloadContext) -> {
            try {
                UniversalInventory blockEntity;
                BlockEntity rawBlockEntity = iPayloadContext.player().level().getBlockEntity(payload.pos());
                if (rawBlockEntity instanceof UniversalInventory && (blockEntity = (UniversalInventory)rawBlockEntity).stillValid(iPayloadContext.player())) {
                    blockEntity.playerUUID = iPayloadContext.player().getUUID();
                    blockEntity.playerName = iPayloadContext.player().getName();
                    if (blockEntity instanceof PlayerInventoryStorageBlockEntity) {
                        PlayerInventoryStorageBlockEntity playerInventoryStorageBlockEntity = (PlayerInventoryStorageBlockEntity)blockEntity;
                        PlayerInventoryStorageBlock.openMenu(iPayloadContext.player(), playerInventoryStorageBlockEntity);
                    } else if (blockEntity instanceof PlayerSlotStorageBlockEntity) {
                        PlayerSlotStorageBlockEntity playerSlotStorageBlockEntity = (PlayerSlotStorageBlockEntity)blockEntity;
                        PlayerSlotStorageBlock.openMenu(iPayloadContext.player(), playerSlotStorageBlockEntity);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        registrar.playToServer(C2SSetSlotId.TYPE, C2SSetSlotId.STREAM_CODEC, (payload, iPayloadContext) -> {
            try {
                PlayerSlotStorageBlockEntity blockEntity;
                BlockEntity rawBlockEntity = iPayloadContext.player().level().getBlockEntity(payload.pos());
                if (rawBlockEntity instanceof PlayerSlotStorageBlockEntity && (blockEntity = (PlayerSlotStorageBlockEntity)rawBlockEntity).stillValid(iPayloadContext.player())) {
                    blockEntity.slotId = Math.clamp((long)payload.slotId(), 0, 40);
                    AbstractContainerMenu patt0$temp = iPayloadContext.player().containerMenu;
                    if (patt0$temp instanceof PlayerSlotStorageMenu) {
                        PlayerSlotStorageMenu menu = (PlayerSlotStorageMenu)patt0$temp;
                        menu.slotId = payload.slotId();
                        menu.updateSlot();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

