/*
 * Decompiled with CFR 0.152.
 */
package com.nottouchedgrass.inventorystorages.blockentities;

import com.nottouchedgrass.inventorystorages.InventoryStorages;
import com.nottouchedgrass.inventorystorages.blocks.PlayerInventoryStorageBlock;
import com.nottouchedgrass.inventorystorages.containers.UniversalInventory;
import com.nottouchedgrass.inventorystorages.menus.PlayerInventoryStorageMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerInventoryStorageBlockEntity
extends UniversalInventory
implements MenuProvider {
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level p_155062_, BlockPos p_155063_, BlockState p_155064_) {
            PlayerInventoryStorageBlockEntity.this.playSound(p_155064_, SoundEvents.ENDER_CHEST_OPEN);
            PlayerInventoryStorageBlockEntity.this.updateBlockState(p_155064_, true);
        }

        protected void onClose(Level p_155072_, BlockPos p_155073_, BlockState p_155074_) {
            PlayerInventoryStorageBlockEntity.this.playSound(p_155074_, SoundEvents.ENDER_CHEST_CLOSE);
            PlayerInventoryStorageBlockEntity.this.updateBlockState(p_155074_, false);
        }

        protected void openerCountChanged(Level p_155066_, BlockPos p_155067_, BlockState p_155068_, int p_155069_, int p_155070_) {
        }

        protected boolean isOwnContainer(Player p_155060_) {
            AbstractContainerMenu abstractContainerMenu = p_155060_.containerMenu;
            if (abstractContainerMenu instanceof PlayerInventoryStorageMenu) {
                PlayerInventoryStorageMenu menu = (PlayerInventoryStorageMenu)abstractContainerMenu;
                Container container = menu.container;
                return container == PlayerInventoryStorageBlockEntity.this;
            }
            return false;
        }
    };

    public PlayerInventoryStorageBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)InventoryStorages.PLAYER_INVENTORY_STORAGE_BLOCK_ENTITY.get(), pos, blockState);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
        return new PlayerInventoryStorageMenu(id, inventory, this, this.playerUUID, this.worldPosition);
    }

    @Override
    @NotNull
    public Component getDisplayName() {
        if (this.playerUUID != null) {
            return Component.translatable((String)"block.inventorystorages.player_inventory_storage.displayname", (Object[])new Object[]{super.getDisplayName()});
        }
        return Component.translatable((String)"block.inventorystorages.player_inventory_storage.displayname.unbound");
    }

    void updateBlockState(BlockState state, boolean open) {
        this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)PlayerInventoryStorageBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
    }

    void playSound(BlockState state, SoundEvent sound) {
        Vec3i vec3i = ((Direction)state.getValue((Property)PlayerInventoryStorageBlock.FACING)).getNormal();
        double d0 = (double)this.worldPosition.getX() + 0.5 + (double)vec3i.getX() / 2.0;
        double d1 = (double)this.worldPosition.getY() + 0.5 + (double)vec3i.getY() / 2.0;
        double d2 = (double)this.worldPosition.getZ() + 0.5 + (double)vec3i.getZ() / 2.0;
        this.level.playSound((Player)null, d0, d1, d2, sound, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }
}

