/*
 * Decompiled with CFR 0.152.
 */
package com.nottouchedgrass.inventorystorages.containers;

import java.io.IOException;
import java.nio.file.Path;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;

public class OfflinePlayerInventory
implements Container,
Nameable {
    private static final int TOTAL_SLOTS = 41;
    private final ItemStack[] contents = new ItemStack[41];
    private final UUID playerUUID;
    private final Level level;
    private Component displayName = Component.literal((String)"Offline Player");

    public OfflinePlayerInventory(Level level, UUID playerUUID) {
        this.level = level;
        this.playerUUID = playerUUID;
        for (int i = 0; i < 41; ++i) {
            this.contents[i] = ItemStack.EMPTY;
        }
        this.load();
    }

    private void load() {
        ServerPlayer serverPlayer = this.level.getServer().getPlayerList().getPlayer(this.playerUUID);
        if (serverPlayer != null) {
            int i;
            for (i = 0; i < 36; ++i) {
                this.contents[i] = serverPlayer.getInventory().getItem(i).copy();
            }
            for (i = 0; i < 4; ++i) {
                this.contents[36 + i] = ((ItemStack)serverPlayer.getInventory().armor.get(i)).copy();
            }
            this.contents[40] = ((ItemStack)serverPlayer.getInventory().offhand.get(0)).copy();
            this.displayName = serverPlayer.getDisplayName();
            return;
        }
        try {
            Path playerdataDir = this.level.getServer().getWorldPath(LevelResource.PLAYER_DATA_DIR);
            Path playerFile = playerdataDir.resolve(this.playerUUID.toString() + ".dat");
            if (!playerFile.toFile().exists()) {
                return;
            }
            CompoundTag playerTag = NbtIo.readCompressed((Path)playerFile, (NbtAccounter)NbtAccounter.unlimitedHeap());
            if (playerTag == null) {
                return;
            }
            ListTag inv = playerTag.getList("Inventory", 10);
            RegistryAccess registries = this.level.registryAccess();
            for (int i = 0; i < inv.size(); ++i) {
                CompoundTag stackTag = inv.getCompound(i);
                byte vanillaSlot = stackTag.getByte("Slot");
                ItemStack stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)stackTag);
                if (stack.isEmpty()) continue;
                if (vanillaSlot >= 0 && vanillaSlot < 36) {
                    this.contents[vanillaSlot] = stack;
                    continue;
                }
                if (vanillaSlot >= 100 && vanillaSlot <= 103) {
                    this.contents[36 + (vanillaSlot - 100)] = stack;
                    continue;
                }
                if (vanillaSlot != -106) continue;
                this.contents[40] = stack;
            }
            if (playerTag.contains("Name", 8)) {
                this.displayName = Component.literal((String)playerTag.getString("Name"));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            int i;
            Path playerdataDir = this.level.getServer().getWorldPath(LevelResource.PLAYER_DATA_DIR);
            Path playerFile = playerdataDir.resolve(this.playerUUID.toString() + ".dat");
            CompoundTag root = playerFile.toFile().exists() ? NbtIo.readCompressed((Path)playerFile, (NbtAccounter)NbtAccounter.unlimitedHeap()) : new CompoundTag();
            ListTag inv = new ListTag();
            RegistryAccess registries = this.level.registryAccess();
            for (i = 0; i < 36; ++i) {
                if (this.contents[i].isEmpty()) continue;
                CompoundTag tag = (CompoundTag)this.contents[i].save((HolderLookup.Provider)registries);
                tag.putByte("Slot", (byte)i);
                inv.add((Object)tag);
            }
            for (i = 0; i < 4; ++i) {
                ItemStack st = this.contents[36 + i];
                if (st.isEmpty()) continue;
                CompoundTag tag = (CompoundTag)st.save((HolderLookup.Provider)registries);
                tag.putByte("Slot", (byte)(100 + i));
                inv.add((Object)tag);
            }
            if (!this.contents[40].isEmpty()) {
                CompoundTag tag = (CompoundTag)this.contents[40].save((HolderLookup.Provider)registries);
                tag.putByte("Slot", (byte)-106);
                inv.add((Object)tag);
            }
            root.put("Inventory", (Tag)inv);
            NbtIo.writeCompressed((CompoundTag)root, (Path)playerFile.toFile().toPath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getContainerSize() {
        return 41;
    }

    public boolean isEmpty() {
        for (ItemStack s : this.contents) {
            if (s.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int i) {
        if (i < 0 || i >= 41) {
            return ItemStack.EMPTY;
        }
        return this.contents[i];
    }

    @NotNull
    public ItemStack removeItem(int i, int count) {
        if (i < 0 || i >= 41) {
            return ItemStack.EMPTY;
        }
        ItemStack current = this.contents[i];
        ItemStack result = current.split(count);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        return result;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int i) {
        if (i < 0 || i >= 41) {
            return ItemStack.EMPTY;
        }
        ItemStack stack = this.contents[i];
        this.contents[i] = ItemStack.EMPTY;
        return stack;
    }

    public void setItem(int i, @NotNull ItemStack itemStack) {
        if (i < 0 || i >= 41) {
            return;
        }
        this.contents[i] = itemStack;
        this.setChanged();
    }

    public void setChanged() {
        this.save();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void clearContent() {
        for (int i = 0; i < 41; ++i) {
            this.contents[i] = ItemStack.EMPTY;
        }
        this.setChanged();
    }

    public Component getName() {
        return this.displayName;
    }
}

