/*
 * Decompiled with CFR 0.152.
 */
package com.nottouchedgrass.inventorystorages.containers;

import com.mojang.serialization.DynamicOps;
import com.nottouchedgrass.inventorystorages.containers.OfflinePlayerInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class UniversalInventory
extends BlockEntity
implements Container {
    public static String playerUUIDKey = "playerUUID";
    public UUID playerUUID;
    public static String playerNameKey = "playerName";
    public Component playerName;

    public UniversalInventory(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public int getContainerSize() {
        if (this.playerUUID != null) {
            return this.getContainer().getContainerSize();
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.getContainer().isEmpty();
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return this.getContainer().getItem(slot);
    }

    public List<ItemStack> getItems() {
        Container container = this.getContainer();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < container.getContainerSize(); ++i) {
            items.add(container.getItem(i));
        }
        return items;
    }

    public ItemStack removeItem(int slot, int amount) {
        return this.getContainer().removeItem(slot, amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.getContainer().removeItemNoUpdate(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.getContainer().setItem(slot, stack);
    }

    public void clearContent() {
        this.getItems().clear();
    }

    public Component getDisplayName() {
        if (this.playerName != null) {
            return this.playerName;
        }
        return Component.translatable((String)"block.inventorystorages.player_inventory_storage.displayname.invalid");
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.hasUUID(playerUUIDKey)) {
            this.playerUUID = tag.getUUID(playerUUIDKey);
        }
        if (tag.contains(playerNameKey)) {
            this.playerName = (Component)ComponentSerialization.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get(playerNameKey)).getOrThrow();
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.playerUUID != null) {
            tag.putUUID(playerUUIDKey, this.playerUUID);
        }
        if (this.playerName != null) {
            tag.put(playerNameKey, (Tag)ComponentSerialization.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.playerName).getOrThrow());
        }
    }

    public boolean stillValid(Player player) {
        return this.level != null && this.level.getBlockEntity(this.worldPosition) == this && player.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public ServerPlayer getPlayerOrNull() {
        return this.level.getServer().getPlayerList().getPlayer(this.playerUUID);
    }

    public Inventory getPlayerInventory() {
        return this.getPlayerOrNull().getInventory();
    }

    public Container getContainer() {
        if (this.playerUUID != null) {
            ServerPlayer player = this.getPlayerOrNull();
            if (player != null) {
                return this.getPlayerInventory();
            }
            return new OfflinePlayerInventory(this.level, this.playerUUID);
        }
        return new SimpleContainer(41);
    }

    public boolean canPlaceItem(int slot, @NotNull ItemStack stack) {
        if (slot >= 36 && slot <= 39) {
            EquipmentSlot eqSlot = EquipmentSlot.values()[slot - 34];
            return new ArmorSlot((Container)this, (LivingEntity)new Zombie(this.level), eqSlot, 0, 0, 0, (ResourceLocation)InventoryMenu.TEXTURE_EMPTY_SLOTS.get(eqSlot)).mayPlace(stack);
        }
        return true;
    }

    public boolean canTakeItem(Container source, int slot, @NotNull ItemStack stack) {
        if (slot >= 36 && slot <= 39) {
            return !EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE);
        }
        return true;
    }
}

