/*
 * Decompiled with CFR 0.152.
 */
package com.nottouchedgrass.inventorystorages.menus;

import com.mojang.datafixers.util.Pair;
import com.nottouchedgrass.inventorystorages.InventoryStorages;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PlayerInventoryStorageMenu
extends AbstractContainerMenu {
    public Container container;
    public BlockPos pos;
    public UUID playerUUID;

    public PlayerInventoryStorageMenu(int id, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        this(id, playerInventory, (Container)new SimpleContainer(41), PlayerInventoryStorageMenu.readUUID(buf), buf.readBlockPos());
    }

    private static UUID readUUID(RegistryFriendlyByteBuf buf) {
        String uuidStr = buf.readUtf();
        return uuidStr.isEmpty() ? null : UUID.fromString(uuidStr);
    }

    public PlayerInventoryStorageMenu(int id, Inventory playerInventory, Container container, UUID playerUUID, BlockPos blockPos) {
        super((MenuType)InventoryStorages.PLAYER_INVENTORY_STORAGE_MENU_TYPE.get(), id);
        int row;
        int col;
        boolean hasPlayer;
        container.startOpen(playerInventory.player);
        this.container = container;
        this.pos = blockPos;
        this.playerUUID = playerUUID;
        int shiftX = 8;
        int shiftY = 4;
        boolean bl = hasPlayer = playerUUID != null;
        if (hasPlayer) {
            for (col = 0; col < 4; ++col) {
                EquipmentSlot slot = EquipmentSlot.values()[col + 2];
                this.addSlot((Slot)new ArmorSlot(container, (LivingEntity)new Zombie(playerInventory.player.level()), slot, 36 + col, shiftX + col * 18, shiftY + 14, (ResourceLocation)InventoryMenu.TEXTURE_EMPTY_SLOTS.get(slot)));
            }
            this.addSlot(new Slot(this, container, 40, shiftX + 4 + 72, shiftY + 14){

                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
                }
            });
            for (row = 0; row < 3; ++row) {
                for (int col2 = 0; col2 < 9; ++col2) {
                    this.addSlot(new Slot(container, col2 + row * 9 + 9, shiftX + col2 * 18, shiftY + 36 + row * 18));
                }
            }
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot(container, col, shiftX + col * 18, shiftY + 90));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (int col3 = 0; col3 < 9; ++col3) {
                this.addSlot(new Slot((Container)playerInventory, col3 + row * 9 + 9, shiftX + col3 * 18, shiftY + 116 + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, shiftX + col * 18, shiftY + 174));
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return this.container.stillValid(player);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        if (this.playerUUID == null) {
            return ItemStack.EMPTY;
        }
        if (player.level().getPlayerByUUID(this.playerUUID) == player) {
            return ItemStack.EMPTY;
        }
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            itemstack = stackInSlot.copy();
            if (index < this.container.getContainerSize() ? !this.moveItemStackTo(stackInSlot, this.container.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(stackInSlot, 0, this.container.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.container.stopOpen(player);
    }
}

