/*
 * Decompiled with CFR 0.152.
 */
package com.nottouchedgrass.inventorystorages.menus;

import com.nottouchedgrass.inventorystorages.InventoryStorages;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PlayerSlotStorageMenu
extends AbstractContainerMenu {
    public Container container;
    public BlockPos pos;
    public UUID playerUUID;
    public int slotId;
    public Slot slot;
    public Inventory playerInventory;
    private int shiftX;
    private int shiftY;

    public PlayerSlotStorageMenu(int id, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        this(id, playerInventory, (Container)new SimpleContainer(1), PlayerSlotStorageMenu.readUUID(buf), buf.readBlockPos(), buf.readInt());
    }

    private static UUID readUUID(RegistryFriendlyByteBuf buf) {
        String uuidStr = buf.readUtf();
        return uuidStr.isEmpty() ? null : UUID.fromString(uuidStr);
    }

    public PlayerSlotStorageMenu(int id, Inventory playerInventory, Container container, UUID playerUUID, BlockPos blockPos, int slotId) {
        super((MenuType)InventoryStorages.PLAYER_SLOT_STORAGE_MENU_TYPE.get(), id);
        boolean hasPlayer;
        container.startOpen(playerInventory.player);
        this.container = container;
        this.pos = blockPos;
        this.playerUUID = playerUUID;
        this.slotId = slotId;
        this.playerInventory = playerInventory;
        this.shiftX = 8;
        this.shiftY = -61;
        boolean bl = hasPlayer = playerUUID != null;
        if (hasPlayer) {
            this.updateSlot();
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, this.shiftX + col * 18, this.shiftY + 116 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, this.shiftX + col * 18, this.shiftY + 174));
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return this.container.stillValid(player);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        if (this.playerUUID == null) {
            return ItemStack.EMPTY;
        }
        if (player.level().getPlayerByUUID(this.playerUUID) == player) {
            return ItemStack.EMPTY;
        }
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            itemstack = stackInSlot.copy();
            if (index < this.container.getContainerSize() ? !this.moveItemStackTo(stackInSlot, this.container.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(stackInSlot, 0, this.container.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.container.stopOpen(player);
    }

    public void updateSlot() {
        Slot newSlot;
        if (this.slotId >= 36 && this.slotId <= 39) {
            EquipmentSlot eqSlot = EquipmentSlot.values()[this.slotId - 34];
            newSlot = new ArmorSlot(this.container, (LivingEntity)new Zombie(this.playerInventory.player.level()), eqSlot, 0, this.shiftX, this.shiftY + 79, (ResourceLocation)InventoryMenu.TEXTURE_EMPTY_SLOTS.get(eqSlot));
        } else {
            newSlot = new Slot(this.container, 0, this.shiftX, this.shiftY + 79);
        }
        if (this.slots.contains((Object)this.slot)) {
            int index = this.slots.indexOf((Object)this.slot);
            this.slots.set(index, (Object)newSlot);
        } else {
            this.addSlot(newSlot);
        }
        this.slot = newSlot;
    }
}

