/*
 * Decompiled with CFR 0.152.
 */
package com.nottouchedgrass.inventorystorages.screens;

import com.nottouchedgrass.inventorystorages.menus.PlayerSlotStorageMenu;
import com.nottouchedgrass.inventorystorages.payloads.C2SSetOwner;
import com.nottouchedgrass.inventorystorages.payloads.C2SSetSlotId;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class PlayerSlotStorageScreen
extends AbstractContainerScreen<PlayerSlotStorageMenu> {
    AbstractButton setOwnerButton;
    EditBox slotIdEditBox;

    public PlayerSlotStorageScreen(PlayerSlotStorageMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 137;
        this.inventoryLabelX = 8;
        this.inventoryLabelY = 43;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"inventorystorages", (String)"textures/gui/player_slot_storage.png");
        guiGraphics.blit(TEXTURE, i, j, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderLabels(guiGraphics, mouseX, mouseY);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"block.inventorystorages.player_slot_storage.slot"), 32, 22, 0x404040, false);
    }

    protected void init() {
        super.init();
        this.setOwnerButton = new AbstractButton(this.leftPos + 145, this.topPos + 18, 24, 16, (Component)Component.literal((String)"Set")){

            protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            }

            public void onPress() {
                PacketDistributor.sendToServer((CustomPacketPayload)new C2SSetOwner(((PlayerSlotStorageMenu)((PlayerSlotStorageScreen)PlayerSlotStorageScreen.this).menu).pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
                ((PlayerSlotStorageMenu)((PlayerSlotStorageScreen)PlayerSlotStorageScreen.this).menu).playerUUID = Minecraft.getInstance().player.getUUID();
            }
        };
        this.addRenderableWidget((GuiEventListener)this.setOwnerButton);
        this.slotIdEditBox = new EditBox(this.font, this.leftPos + 56, this.topPos + 16, 60, 20, (Component)Component.translatable((String)"block.inventorystorages.player_slot_storage.slot"));
        this.slotIdEditBox.setValue(String.valueOf(((PlayerSlotStorageMenu)this.menu).slotId));
        this.slotIdEditBox.setMaxLength(2);
        this.slotIdEditBox.setFilter(text -> {
            if (text.isEmpty()) {
                return true;
            }
            if (text.matches("\\d{1,2}")) {
                try {
                    int value = Integer.parseInt(text);
                    return value >= 0 && value <= 40;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return false;
        });
        this.slotIdEditBox.setResponder(text -> {
            int slotId;
            if (!this.slotIdEditBox.isFocused()) {
                if (text.isEmpty()) {
                    this.slotIdEditBox.setValue("0");
                } else {
                    int value = Integer.parseInt(text);
                    if (value < 0) {
                        this.slotIdEditBox.setValue("0");
                    } else if (value > 40) {
                        this.slotIdEditBox.setValue("40");
                    }
                }
            }
            try {
                slotId = Integer.parseInt(text);
            }
            catch (Exception e) {
                slotId = 0;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new C2SSetSlotId(((PlayerSlotStorageMenu)this.menu).pos, slotId), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (((PlayerSlotStorageMenu)this.menu).playerUUID != null) {
                ((PlayerSlotStorageMenu)this.menu).slotId = slotId;
                ((PlayerSlotStorageMenu)this.menu).updateSlot();
            }
        });
        this.addRenderableWidget((GuiEventListener)this.slotIdEditBox);
    }
}

