/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.timberz.listener;

import com.zetaplugins.timberz.TimberZ;
import com.zetaplugins.timberz.service.MaterialTypeChecks;
import com.zetaplugins.timberz.service.PlayerStateService;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.inventory.ItemStack;

public class LeafBreakListener
implements Listener {
    private final TimberZ plugin;
    private final PlayerStateService playerStateService;

    public LeafBreakListener(TimberZ plugin) {
        this.plugin = plugin;
        this.playerStateService = plugin.getPlayerStateService();
    }

    @EventHandler
    public void onBlockBreak(BlockDamageEvent event) {
        Block brokenBlock = event.getBlock();
        Material blockType = brokenBlock.getType();
        Player player = event.getPlayer();
        if (!this.plugin.getConfig().getBoolean("instaBreakLeavesWithTimber", false)) {
            return;
        }
        List<Material> leafTypes = this.getLeafTypes();
        if (!leafTypes.contains(blockType)) {
            return;
        }
        if (!this.playerStateService.isAllowedToTimber(player)) {
            return;
        }
        ItemStack tool = player.getInventory().getItemInMainHand();
        if (tool.getType() == Material.AIR || !MaterialTypeChecks.isValidAxe(tool, this.plugin)) {
            return;
        }
        brokenBlock.breakNaturally(tool);
        player.playSound(player.getLocation(), Sound.BLOCK_GRASS_BREAK, 1.0f, 1.0f);
    }

    private List<Material> getLeafTypes() {
        List leafTypes = this.plugin.getConfigService().getBlocksConfig().getStringList("leafBlocks");
        ArrayList<Material> leafMaterials = new ArrayList<Material>();
        for (String leafType : leafTypes) {
            try {
                Material material = Material.getMaterial((String)leafType);
                if (material != null) {
                    leafMaterials.add(material);
                    continue;
                }
                this.plugin.getLogger().warning("Invalid leaf block type in config: " + leafType);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return leafMaterials;
    }
}

