/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.timberz.service;

import com.zetaplugins.timberz.TimberZ;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public final class TreeDetectionService {
    private final TimberZ plugin;
    private final int MAX_TREE_SIZE;
    private final int MAX_SEARCH_RADIUS;
    private final int DIAGONAL_SEARCH_RANGE;
    private final int MIN_LEAVES_REQUIRED;
    private final int MIN_LOGS_REQUIRED;
    private final Map<Material, Material> LOG_TO_LEAF_MAP = new HashMap<Material, Material>();

    public TreeDetectionService(TimberZ plugin) {
        this.plugin = plugin;
        this.MAX_TREE_SIZE = plugin.getConfig().getInt("maxTreeSize", 1000);
        this.MAX_SEARCH_RADIUS = plugin.getConfig().getInt("maxSearchRadius", 1);
        this.DIAGONAL_SEARCH_RANGE = plugin.getConfig().getInt("diagonalSearchRange", 2);
        this.MIN_LEAVES_REQUIRED = plugin.getConfig().getInt("minLeavesRequired", 5);
        this.MIN_LOGS_REQUIRED = plugin.getConfig().getInt("minLogsRequired", 3);
        this.fetchLogToLeaveMap();
    }

    public void fetchLogToLeaveMap() {
        this.LOG_TO_LEAF_MAP.clear();
        List logToLeaveList = this.plugin.getConfigService().getBlocksConfig().getStringList("logToLeafMap");
        for (String entry : logToLeaveList) {
            String[] parts = entry.split(":");
            if (parts.length != 2) continue;
            Material logType = Material.getMaterial((String)parts[0].toUpperCase());
            Material leafType = Material.getMaterial((String)parts[1].toUpperCase());
            if (logType == null || leafType == null) continue;
            this.LOG_TO_LEAF_MAP.put(logType, leafType);
        }
    }

    public Set<Block> identifyTreeStructure(Block sourceBlock) {
        HashSet<Block> visited;
        Set<Block> connectedLogs;
        Material sourceType = sourceBlock.getType();
        Material matchingLeafType = this.LOG_TO_LEAF_MAP.get(sourceType);
        if (matchingLeafType == null) {
            return Collections.emptySet();
        }
        Block blockAbove = sourceBlock.getRelative(BlockFace.UP);
        if (!this.isMatchingLog(blockAbove, sourceType)) {
            boolean hasDiagonalUpward;
            Block diagonallyAbove1 = sourceBlock.getRelative(1, 1, 0);
            Block diagonallyAbove2 = sourceBlock.getRelative(-1, 1, 0);
            Block diagonallyAbove3 = sourceBlock.getRelative(0, 1, 1);
            Block diagonallyAbove4 = sourceBlock.getRelative(0, 1, -1);
            boolean bl = hasDiagonalUpward = this.isMatchingLog(diagonallyAbove1, sourceType) || this.isMatchingLog(diagonallyAbove2, sourceType) || this.isMatchingLog(diagonallyAbove3, sourceType) || this.isMatchingLog(diagonallyAbove4, sourceType);
            if (!hasDiagonalUpward) {
                return Collections.emptySet();
            }
        }
        if ((connectedLogs = this.findConnectedLogs(sourceBlock, sourceType, visited = new HashSet<Block>())).size() < this.MIN_LOGS_REQUIRED) {
            return Collections.emptySet();
        }
        boolean hasLeaves = this.validateLeaves(connectedLogs, matchingLeafType);
        if (!hasLeaves) {
            return Collections.emptySet();
        }
        return connectedLogs;
    }

    private Set<Block> findConnectedLogs(Block sourceBlock, Material logType, Set<Block> visited) {
        LinkedList<Block> queue = new LinkedList<Block>();
        HashSet<Block> connectedLogs = new HashSet<Block>();
        queue.add(sourceBlock);
        visited.add(sourceBlock);
        connectedLogs.add(sourceBlock);
        while (!queue.isEmpty() && connectedLogs.size() < this.MAX_TREE_SIZE) {
            Block current = (Block)queue.poll();
            for (BlockFace face : Arrays.asList(BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST)) {
                Block adjacent = current.getRelative(face);
                if (visited.contains(adjacent) || !this.isMatchingLog(adjacent, logType)) continue;
                queue.add(adjacent);
                visited.add(adjacent);
                connectedLogs.add(adjacent);
            }
            for (int x = -this.DIAGONAL_SEARCH_RANGE; x <= this.DIAGONAL_SEARCH_RANGE; ++x) {
                for (int y = -this.DIAGONAL_SEARCH_RANGE; y <= this.DIAGONAL_SEARCH_RANGE; ++y) {
                    for (int z = -this.DIAGONAL_SEARCH_RANGE; z <= this.DIAGONAL_SEARCH_RANGE; ++z) {
                        Block diagonal;
                        if (x == 0 && y == 0 && z == 0 || Math.abs(x) + Math.abs(y) + Math.abs(z) <= 1 || visited.contains(diagonal = current.getRelative(x, y, z)) || !this.isMatchingLog(diagonal, logType) || !this.isDiagonalConnectionValid(current, diagonal, logType, connectedLogs)) continue;
                        queue.add(diagonal);
                        visited.add(diagonal);
                        connectedLogs.add(diagonal);
                    }
                }
            }
        }
        return connectedLogs;
    }

    private boolean isDiagonalConnectionValid(Block block1, Block block2, Material logType, Set<Block> knownTreeLogs) {
        int xDiff = Math.abs(block1.getX() - block2.getX());
        int yDiff = Math.abs(block1.getY() - block2.getY());
        int zDiff = Math.abs(block1.getZ() - block2.getZ());
        if (xDiff > this.DIAGONAL_SEARCH_RANGE || yDiff > this.DIAGONAL_SEARCH_RANGE || zDiff > this.DIAGONAL_SEARCH_RANGE) {
            return false;
        }
        boolean isUpwardDiagonal = block2.getY() > block1.getY();
        int bridgeLogsFound = 0;
        for (int x = Math.min(block1.getX(), block2.getX()); x <= Math.max(block1.getX(), block2.getX()); ++x) {
            for (int y = Math.min(block1.getY(), block2.getY()); y <= Math.max(block1.getY(), block2.getY()); ++y) {
                for (int z = Math.min(block1.getZ(), block2.getZ()); z <= Math.max(block1.getZ(), block2.getZ()); ++z) {
                    Block between = block1.getWorld().getBlockAt(x, y, z);
                    if (between.equals((Object)block1) || between.equals((Object)block2) || !knownTreeLogs.contains(between) && !this.isMatchingLog(between, logType)) continue;
                    ++bridgeLogsFound;
                }
            }
        }
        if (isUpwardDiagonal) {
            return true;
        }
        if (bridgeLogsFound > 0) {
            return true;
        }
        return xDiff + yDiff + zDiff <= 3;
    }

    private boolean validateLeaves(Set<Block> connectedLogs, Material leafType) {
        int leafCount = 0;
        HashSet<Block> checkedBlocks = new HashSet<Block>();
        for (Block log : connectedLogs) {
            for (int x = -this.MAX_SEARCH_RADIUS; x <= this.MAX_SEARCH_RADIUS; ++x) {
                for (int y = -this.MAX_SEARCH_RADIUS; y <= this.MAX_SEARCH_RADIUS; ++y) {
                    for (int z = -this.MAX_SEARCH_RADIUS; z <= this.MAX_SEARCH_RADIUS; ++z) {
                        Block checkBlock = log.getRelative(x, y, z);
                        if (checkedBlocks.contains(checkBlock)) continue;
                        checkedBlocks.add(checkBlock);
                        if (checkBlock.getType() != leafType || ++leafCount < this.MIN_LEAVES_REQUIRED) continue;
                        return true;
                    }
                }
            }
        }
        return leafCount >= this.MIN_LEAVES_REQUIRED;
    }

    private boolean isMatchingLog(Block block, Material logType) {
        return block.getType() == logType;
    }

    public boolean containsLog(Material blockType) {
        return this.LOG_TO_LEAF_MAP.containsKey(blockType);
    }

    public Material getLeafType(Material logType) {
        return this.LOG_TO_LEAF_MAP.get(logType);
    }
}

