/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.timberz.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.zetaplugins.timberz.TimberZ;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;

public final class VersionChecker {
    private final TimberZ plugin;
    private final Logger logger;
    private final String modrinthProjectId;
    private boolean newVersionAvailable = false;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public VersionChecker(TimberZ plugin, String modrinthProjectId) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
        this.modrinthProjectId = modrinthProjectId;
        this.checkForUpdates();
    }

    private String getModrinthProjectUrl() {
        return "https://api.modrinth.com/v2/project/" + this.modrinthProjectId;
    }

    private void checkForUpdates() {
        String latestVersion = this.fetchLatestVersion();
        if (latestVersion != null) {
            String currentVersion = this.plugin.getDescription().getVersion();
            if (!latestVersion.trim().equals(currentVersion.trim())) {
                this.newVersionAvailable = true;
                String reset = "\u001b[0m";
                String bold = "\u001b[1m";
                String darkGray = "\u001b[90m";
                String lightGray = "\u001b[37m";
                String green = "\u001b[32m";
                String message = "\n\u001b[90m==========================================\u001b[0m\n\u001b[1mA new version of TimberZ is available!\u001b[0m\n\u001b[1mNew Version: \u001b[0m\u001b[37m" + currentVersion + " -> \u001b[1m\u001b[32m" + latestVersion + "\u001b[0m\n\u001b[1mDownload here: \u001b[0m\u001b[37mhttps://modrinth.com/plugin/timberz/version/" + latestVersion + "\n\u001b[90m==========================================\u001b[0m";
                this.logger.info(message);
            }
        }
    }

    private String fetchLatestVersion() {
        String mcVersion = this.plugin.getServer().getMinecraftVersion();
        String encodedGameVersion = URLEncoder.encode("[\"" + mcVersion + "\"]", StandardCharsets.UTF_8);
        String versionsUrl = this.getModrinthProjectUrl() + "/version?game_versions=" + encodedGameVersion;
        JsonNode versionsArray = this.fetchJsonArrayFromUrl(versionsUrl);
        if (versionsArray != null && versionsArray.isArray() && versionsArray.size() > 0) {
            JsonNode latestVersionNode = versionsArray.get(0);
            return latestVersionNode.get("version_number").asText();
        }
        return null;
    }

    private JsonNode fetchJsonFromUrl(String urlString) {
        try {
            HttpURLConnection connection = this.createHttpConnection(urlString);
            if (connection.getResponseCode() == 200) {
                String response = this.readResponse(connection);
                return OBJECT_MAPPER.readTree(response);
            }
            this.logger.warning("Failed to retrieve data from " + urlString + " Response code: " + connection.getResponseCode());
        }
        catch (IOException e) {
            this.logger.warning("Error fetching data: " + e.getMessage());
        }
        return null;
    }

    private JsonNode fetchJsonArrayFromUrl(String urlString) {
        return this.fetchJsonFromUrl(urlString);
    }

    private HttpURLConnection createHttpConnection(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        return connection;
    }

    private String readResponse(HttpURLConnection connection) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            String string = response.toString();
            return string;
        }
    }

    public boolean isNewVersionAvailable() {
        return this.newVersionAvailable;
    }
}

