/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.timberz.service.worldguard;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import com.zetaplugins.timberz.TimberZ;
import com.zetaplugins.timberz.service.worldguard.TimberFlag;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public final class WorldGuardManager {
    private StateFlag TIMBER_FLAG;

    public WorldGuardManager() {
        this.registerFlags();
    }

    private void registerFlags() {
        TimberFlag timberFlag = new TimberFlag();
        WorldGuard.getInstance().getFlagRegistry().register((Flag)timberFlag);
        this.TIMBER_FLAG = timberFlag;
    }

    public StateFlag getTimberFlag() {
        return this.TIMBER_FLAG;
    }

    public static boolean checkTimberFlag(Player player, TimberZ plugin) {
        WorldGuardManager worldGuardManager = plugin.getWorldGuardManager();
        if (worldGuardManager == null) {
            return true;
        }
        LocalPlayer localPlayer = WorldGuardPlugin.inst().wrapPlayer(player);
        com.sk89q.worldedit.util.Location loc = BukkitAdapter.adapt((Location)player.getLocation());
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        ApplicableRegionSet set = query.getApplicableRegions(loc);
        return set.testState((RegionAssociable)localPlayer, new StateFlag[]{worldGuardManager.getTimberFlag()});
    }
}

