/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.timberz.listener;

import com.zetaplugins.timberz.TimberZ;
import com.zetaplugins.timberz.service.MaterialTypeChecks;
import com.zetaplugins.timberz.service.MessageService;
import com.zetaplugins.timberz.service.PlayerStateService;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;

public final class AxeEquipListener
implements Listener {
    private final TimberZ plugin;
    private final PlayerStateService playerStateService;
    private final boolean toggleTimber;
    private final boolean requireAxeMaterial;

    public AxeEquipListener(TimberZ plugin) {
        this.plugin = plugin;
        this.playerStateService = plugin.getPlayerStateService();
        this.toggleTimber = plugin.getConfig().getBoolean("toggleTimber");
        this.requireAxeMaterial = plugin.getConfig().getBoolean("requireAxeMaterial");
    }

    @EventHandler
    public void onPlayerSwapHandItems(PlayerSwapHandItemsEvent event) {
        if (!this.requireAxeMaterial) {
            return;
        }
        Player player = event.getPlayer();
        if (player.isSneaking()) {
            return;
        }
        if (!player.hasPermission("timberz.useTimber") && this.toggleTimber) {
            return;
        }
        if (!this.toggleTimber) {
            return;
        }
        ItemStack main = event.getMainHandItem();
        ItemStack off = event.getOffHandItem();
        if (MaterialTypeChecks.isValidAxe(main, this.plugin) || MaterialTypeChecks.isValidAxe(off, this.plugin)) {
            event.setCancelled(true);
            this.playerStateService.toggleTimberState(player);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player && this.toggleTimber && this.requireAxeMaterial)) {
            return;
        }
        ItemStack cursor = event.getCursor();
        if (event.getSlot() == 40 && this.isAxeFromItemStack(cursor)) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        Player player;
        block6: {
            block5: {
                HumanEntity humanEntity = event.getWhoClicked();
                if (!(humanEntity instanceof Player)) break block5;
                player = (Player)humanEntity;
                if (this.toggleTimber && this.requireAxeMaterial) break block6;
            }
            return;
        }
        ItemStack dragged = event.getOldCursor();
        if (!this.isAxeFromItemStack(dragged)) {
            return;
        }
        if (event.getRawSlots().contains(40)) {
            event.setCancelled(true);
            player.sendMessage(this.plugin.getMessageService().getAndFormatMsg(false, "cannotDragAxesIntoOffHand", "&cYou cannot drag axes into your offhand!", new MessageService.Replaceable[0]));
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.playerStateService.cleanupPlayer(player);
    }

    private boolean isAxeFromItemStack(ItemStack item) {
        return MaterialTypeChecks.isAxe(item.getType(), this.plugin.getConfigService().getBlocksConfig());
    }
}

