/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.timberz.service;

import com.zetaplugins.timberz.TimberZ;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.inventory.ItemStack;

public final class MaterialTypeChecks {
    private MaterialTypeChecks() {
    }

    public static boolean isLeafBlock(Material material, FileConfiguration blocksConfig) {
        List leafBlocks = blocksConfig.getStringList("leafBlocks");
        for (String leafBlock : leafBlocks) {
            if (!material.toString().equalsIgnoreCase(leafBlock)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAxe(Material material, FileConfiguration blocksConfig) {
        List axeBlocks = blocksConfig.getStringList("axes");
        for (String axeBlock : axeBlocks) {
            if (!material.toString().equalsIgnoreCase(axeBlock)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidAxe(ItemStack item, TimberZ plugin) {
        Map enchants;
        Set enchantKeys;
        boolean isAxe = MaterialTypeChecks.isAxe(item.getType(), plugin.getConfigService().getBlocksConfig());
        boolean requireAxeMaterial = plugin.getConfig().getBoolean("requireAxeMaterial");
        if (item == null || !isAxe && requireAxeMaterial) {
            return false;
        }
        if (plugin.getConfig().getBoolean("restrictAxeModelData")) {
            if (!item.getItemMeta().hasCustomModelData()) {
                return false;
            }
            int itemCustomModelData = item.getItemMeta().getCustomModelData();
            List allowedModelData = plugin.getConfig().getIntegerList("allowedModelData");
            if (!allowedModelData.contains(itemCustomModelData)) {
                return false;
            }
        }
        return !plugin.getConfig().getBoolean("requireCustomEnchant") || (enchantKeys = (enchants = item.getEnchantments()).keySet().stream().map(Keyed::getKey).map(Object::toString).collect(Collectors.toSet())).contains("timberz:timber");
    }
}

