/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.timberz.service;

import com.zetaplugins.timberz.TimberZ;
import com.zetaplugins.timberz.service.MessageService;
import com.zetaplugins.timberz.service.worldguard.WorldGuardManager;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public final class PlayerStateService {
    private final TimberZ plugin;
    private final String METADATA_KEY = "TimberZ_toggle";
    private final Map<Player, BukkitTask> actionBarTasks = new HashMap<Player, BukkitTask>();

    public PlayerStateService(TimberZ plugin) {
        this.plugin = plugin;
    }

    public boolean isAllowedToTimber(Player player) {
        if (!player.hasPermission("timberz.usetimber")) {
            return false;
        }
        if (this.plugin.getConfig().getBoolean("toggleTimber") && !this.getToggleMetadata(player)) {
            return false;
        }
        if (!this.plugin.hasWorldGuard()) {
            return true;
        }
        if (WorldGuardManager.checkTimberFlag(player, this.plugin)) {
            return true;
        }
        if (this.plugin.getConfig().getBoolean("messageOnRegionViolation")) {
            player.sendMessage(this.plugin.getMessageService().getAndFormatMsg(false, "noTimberInThisRegion", "&cYou cannot use TimberZ in this region!", new MessageService.Replaceable[0]));
        }
        return false;
    }

    private boolean getToggleMetadata(Player player) {
        if (!player.hasMetadata("TimberZ_toggle")) {
            return false;
        }
        for (MetadataValue value : player.getMetadata("TimberZ_toggle")) {
            if (!value.getOwningPlugin().equals((Object)this.plugin)) continue;
            return value.asBoolean();
        }
        return false;
    }

    public void setTimberEnabled(Player player, boolean state) {
        player.setMetadata("TimberZ_toggle", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)state));
        if (state) {
            this.startActionBar(player);
        } else {
            this.stopActionBar(player);
            player.sendActionBar(this.plugin.getMessageService().getAndFormatMsg(false, "timberModeOff", "&7Timber: &cOFF&7", new MessageService.Replaceable[0]));
        }
    }

    public void toggleTimberState(Player player) {
        boolean currentState = this.getToggleMetadata(player);
        if (!this.plugin.getConfig().getBoolean("toggleTimber") && !currentState) {
            return;
        }
        this.setTimberEnabled(player, !currentState);
    }

    public void startActionBar(Player player) {
        this.stopActionBar(player);
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (!player.isOnline()) {
                this.stopActionBar(player);
                return;
            }
            player.sendActionBar(this.plugin.getMessageService().getAndFormatMsg(false, "timberModeOn", "&7Timber: &aON&7", new MessageService.Replaceable[0]));
        }, 0L, 40L);
        this.actionBarTasks.put(player, task);
    }

    public void stopActionBar(Player player) {
        BukkitTask task = this.actionBarTasks.remove(player);
        if (task != null) {
            task.cancel();
        }
    }

    public void cleanupPlayer(Player player) {
        this.stopActionBar(player);
    }

    public void cleanupAll() {
        for (BukkitTask task : this.actionBarTasks.values()) {
            task.cancel();
        }
        this.actionBarTasks.clear();
    }
}

