/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.timberz;

import com.zetaplugins.timberz.commands.TimberZCommand;
import com.zetaplugins.timberz.dev.DevMode;
import com.zetaplugins.timberz.service.ConfigService;
import com.zetaplugins.timberz.service.LocalizationService;
import com.zetaplugins.timberz.service.MessageService;
import com.zetaplugins.timberz.service.PlayerStateService;
import com.zetaplugins.timberz.service.TreeDetectionService;
import com.zetaplugins.timberz.service.TreeFellerService;
import com.zetaplugins.timberz.service.VersionChecker;
import com.zetaplugins.timberz.service.auraskills.AuraSkillsManager;
import com.zetaplugins.timberz.service.bstats.Metrics;
import com.zetaplugins.timberz.service.papi.PapiExpansion;
import com.zetaplugins.timberz.service.registrars.EventRegistrar;
import com.zetaplugins.timberz.service.worldguard.WorldGuardManager;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import java.nio.file.Path;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class TimberZ
extends JavaPlugin
implements Listener {
    private PlayerStateService playerStateService;
    private MessageService messageService;
    private LocalizationService localizationService;
    private TreeFellerService treeFellerService;
    private TreeDetectionService treeDetectionService;
    private VersionChecker versionChecker;
    private ConfigService configService;
    private WorldGuardManager worldGuardManager;
    private AuraSkillsManager auraSkillsManager;
    private final boolean hasWorldGuard = Bukkit.getPluginManager().getPlugin("WorldGuard") != null;
    private final boolean hasAuraSkills = Bukkit.getPluginManager().getPlugin("AuraSkills") != null;
    private boolean devMode = false;

    public void onLoad() {
        this.getLogger().info("Loading TimberZ...");
        if (Bukkit.getName().toLowerCase().contains("spigot") || Bukkit.getName().toLowerCase().contains("craftbukkit")) {
            this.getLogger().severe("---------------------------------------------------");
            this.getLogger().severe("TimberZ does not support Spigot or Bukkit!");
            this.getLogger().severe("Please use Paper or any fork of Paper (like Purpur). If you need further assistance, please join our Discord server:");
            this.getLogger().severe("https://strassburger.org/discord");
            this.getLogger().severe("---------------------------------------------------");
        }
        if (this.hasWorldGuard()) {
            this.getLogger().info("WorldGuard found! Enabling WorldGuard support...");
            this.worldGuardManager = new WorldGuardManager();
            this.getLogger().info("WorldGuard support enabled!");
        } else {
            this.getLogger().warning("WorldGuard not found! Disabling WorldGuard support.");
        }
    }

    public void onEnable() {
        String mode = System.getProperty("plugin.env", "release");
        this.devMode = mode.equalsIgnoreCase("dev");
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        this.localizationService = new LocalizationService(this);
        this.messageService = new MessageService(this);
        this.versionChecker = new VersionChecker(this, "hjNMOOnF");
        this.configService = new ConfigService(this);
        this.playerStateService = new PlayerStateService(this);
        this.treeFellerService = new TreeFellerService(this);
        this.treeDetectionService = new TreeDetectionService(this);
        this.configService.initConfigs();
        new EventRegistrar(this).registerListeners();
        this.registerCommands();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.initializeBStats();
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.getLogger().info("PlaceholderAPI found! Registering placeholders...");
            new PapiExpansion(this).register();
            this.getLogger().info("Placeholders registered successfully!");
        }
        if (this.hasAuraSkills) {
            this.getLogger().info("AuraSkills found! Enabling AuraSkills support...");
            this.auraSkillsManager = new AuraSkillsManager(this);
            this.getLogger().info("AuraSkills support enabled!");
        }
        if (this.devMode) {
            new DevMode(this).enable();
        }
        this.getLogger().info("TimberZ has been enabled!");
    }

    @NotNull
    public Path getDataPath() {
        return super.getDataPath();
    }

    public void onDisable() {
        if (this.playerStateService != null) {
            this.playerStateService.cleanupAll();
        }
        this.getLogger().info("TimberZ has been disabled!");
    }

    private void registerCommands() {
        this.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, commands -> {
            ((Commands)commands.registrar()).register(new TimberZCommand(this).buildRootCommand("timberz"));
            ((Commands)commands.registrar()).register(new TimberZCommand(this).buildRootCommand("tz"));
        });
    }

    private void initializeBStats() {
        int pluginId = 25743;
        Metrics metrics = new Metrics(this, pluginId);
        metrics.addCustomChart(new Metrics.SimplePie("language", () -> this.getConfig().getString("lang")));
    }

    public PlayerStateService getPlayerStateService() {
        return this.playerStateService;
    }

    public MessageService getMessageService() {
        return this.messageService;
    }

    public LocalizationService getLocalizationService() {
        return this.localizationService;
    }

    public TreeFellerService getTreeFellerService() {
        return this.treeFellerService;
    }

    public VersionChecker getVersionChecker() {
        return this.versionChecker;
    }

    public TreeDetectionService getTreeDetectionService() {
        return this.treeDetectionService;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public WorldGuardManager getWorldGuardManager() {
        return this.worldGuardManager;
    }

    public boolean hasWorldGuard() {
        return this.hasWorldGuard;
    }

    public AuraSkillsManager getAuraSkillsManager() {
        return this.auraSkillsManager;
    }

    public boolean hasAuraSkills() {
        return this.hasAuraSkills;
    }
}

