/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.timberz.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.zetaplugins.timberz.TimberZ;
import com.zetaplugins.timberz.service.MessageService;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class TimberZCommand {
    private final TimberZ plugin;

    public TimberZCommand(TimberZ plugin) {
        this.plugin = plugin;
    }

    public LiteralCommandNode<CommandSourceStack> buildRootCommand(String commandName) {
        boolean isToggleEnabled = this.plugin.getConfig().getBoolean("toggleTimber");
        LiteralArgumentBuilder root = Commands.literal((String)commandName);
        root.executes(this::executeVersion);
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(source -> source.getSender().hasPermission("timberz.admin"))).executes(this::executeReload));
        root.then(Commands.literal((String)"help").executes(this::executeHelp));
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"toggle").requires(source -> source.getSender().hasPermission("timberz.usetimber") && isToggleEnabled)).executes(this::executeToggle));
        return root.build();
    }

    private int executeVersion(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).getSender().sendMessage(this.plugin.getMessageService().getAndFormatMsg(true, "versionMsg", "&7You are using version %ac%%version%", new MessageService.Replaceable<String>("%version%", this.plugin.getDescription().getVersion())));
        return 1;
    }

    private int executeHelp(CommandContext<CommandSourceStack> context) {
        ((CommandSourceStack)context.getSource()).getSender().sendMessage(this.plugin.getMessageService().getAndFormatMsg(false, "help", "\\n &8<b>></b> <#00D26A><b><gradient:#00D26A:#00B24F>ServerLinksZ</gradient></b></#00D26A> <grey>v%version%</grey>\\n\\n <click:OPEN_URL:https://docs.zetaplugins.com/timberz>%ac%<u><b>Documentation</b></u></click>   <click:OPEN_URL:https://strassburger.org/discord>%ac%<u><b>Support Discord</b></u></click>\\n", new MessageService.Replaceable<String>("%version%", this.plugin.getDescription().getVersion())));
        return 1;
    }

    private int executeReload(CommandContext<CommandSourceStack> context) {
        this.plugin.getConfigService().initConfigs();
        this.plugin.reloadConfig();
        this.plugin.getLocalizationService().reload();
        this.plugin.getTreeDetectionService().fetchLogToLeaveMap();
        this.plugin.getPlayerStateService().cleanupAll();
        ((CommandSourceStack)context.getSource()).getSender().sendMessage(this.plugin.getMessageService().getAndFormatMsg(true, "reloadMsg", "&7Successfully reloaded the plugin!", new MessageService.Replaceable[0]));
        return 1;
    }

    private int executeToggle(CommandContext<CommandSourceStack> context) {
        CommandSender sender = ((CommandSourceStack)context.getSource()).getSender();
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessageService().getAndFormatMsg(false, "playerOnlyCommand", "This command can only be used by players!", new MessageService.Replaceable[0]));
            return 1;
        }
        Player player = (Player)sender;
        this.plugin.getPlayerStateService().toggleTimberState(player);
        return 1;
    }
}

