/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.timberz.handler;

import com.zetaplugins.timberz.TimberZ;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class SaplingReplanter {
    private final TimberZ plugin;
    private final Map<Material, Material> LOG_TO_SAPLING_MAP = new HashMap<Material, Material>();

    public SaplingReplanter(TimberZ plugin) {
        this.plugin = plugin;
        this.fetchLogToSaplingMap();
    }

    private void fetchLogToSaplingMap() {
        List logToSaplingMap = this.plugin.getConfigService().getBlocksConfig().getStringList("logToSaplingMap");
        for (String entry : logToSaplingMap) {
            String[] parts = entry.split(":");
            if (parts.length != 2) continue;
            Material logType = Material.getMaterial((String)parts[0].toUpperCase());
            Material saplingType = Material.getMaterial((String)parts[1].toUpperCase());
            if (logType == null || saplingType == null) continue;
            this.LOG_TO_SAPLING_MAP.put(logType, saplingType);
        }
    }

    public TreeInfo analyzeTreeType(Block sourceBlock, Set<Block> treeBlocks) {
        Material logType = sourceBlock.getType();
        Material saplingType = this.LOG_TO_SAPLING_MAP.get(logType);
        if (saplingType == null) {
            return null;
        }
        List<Block> baseBlocks = this.findBaseBlocks(treeBlocks);
        if (baseBlocks.isEmpty()) {
            return null;
        }
        boolean is2x2 = this.is2x2Pattern(baseBlocks);
        return new TreeInfo(saplingType, baseBlocks, is2x2);
    }

    public void scheduleSaplingReplant(final TreeInfo treeInfo) {
        new BukkitRunnable(){

            public void run() {
                if (treeInfo.is2x2Pattern) {
                    SaplingReplanter.this.plantSaplings2x2(treeInfo);
                } else {
                    Block base = treeInfo.baseBlocks.get(0);
                    Block ground = base.getRelative(BlockFace.DOWN);
                    Block airBlock = ground.getRelative(BlockFace.UP);
                    if (SaplingReplanter.this.canPlaceSaplingAt(airBlock)) {
                        airBlock.setType(treeInfo.saplingType);
                    }
                }
            }
        }.runTaskLater((Plugin)this.plugin, 60L);
    }

    private void plantSaplings2x2(TreeInfo treeInfo) {
        if (treeInfo.baseBlocks.size() < 4) {
            return;
        }
        int minX = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (Block base : treeInfo.baseBlocks) {
            minX = Math.min(minX, base.getX());
            minZ = Math.min(minZ, base.getZ());
        }
        int groundY = treeInfo.baseBlocks.get(0).getRelative(BlockFace.DOWN).getY();
        for (int xOffset = 0; xOffset < 2; ++xOffset) {
            for (int zOffset = 0; zOffset < 2; ++zOffset) {
                Location saplingLoc = new Location(treeInfo.baseBlocks.get(0).getWorld(), (double)(minX + xOffset), (double)(groundY + 1), (double)(minZ + zOffset));
                Block airBlock = saplingLoc.getBlock();
                if (!this.canPlaceSaplingAt(airBlock)) continue;
                airBlock.setType(treeInfo.saplingType);
            }
        }
    }

    private List<Block> findBaseBlocks(Set<Block> treeBlocks) {
        int minY = Integer.MAX_VALUE;
        for (Block block : treeBlocks) {
            minY = Math.min(minY, block.getY());
        }
        ArrayList<Block> baseBlocks = new ArrayList<Block>();
        for (Block block : treeBlocks) {
            if (block.getY() != minY) continue;
            baseBlocks.add(block);
        }
        return baseBlocks;
    }

    private boolean is2x2Pattern(List<Block> baseBlocks) {
        if (baseBlocks.size() < 4) {
            return false;
        }
        HashSet<Integer> xCoords = new HashSet<Integer>();
        HashSet<Integer> zCoords = new HashSet<Integer>();
        for (Block block : baseBlocks) {
            xCoords.add(block.getX());
            zCoords.add(block.getZ());
        }
        return xCoords.size() == 2 && zCoords.size() == 2;
    }

    private boolean canPlaceSaplingAt(Block block) {
        if (!block.getType().isAir() && block.getType().isSolid() && block.getType() != Material.SNOW) {
            return false;
        }
        Block below = block.getRelative(BlockFace.DOWN);
        Material belowType = below.getType();
        return belowType == Material.GRASS_BLOCK || belowType == Material.DIRT || belowType == Material.COARSE_DIRT || belowType == Material.PODZOL || belowType == Material.FARMLAND || belowType == Material.ROOTED_DIRT;
    }

    public static class TreeInfo {
        public final Material saplingType;
        public final List<Block> baseBlocks;
        public final boolean is2x2Pattern;

        public TreeInfo(Material saplingType, List<Block> baseBlocks, boolean is2x2Pattern) {
            this.saplingType = saplingType;
            this.baseBlocks = baseBlocks;
            this.is2x2Pattern = is2x2Pattern;
        }
    }
}

