/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.timberz.handler;

import com.zetaplugins.timberz.TimberZ;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Random;
import java.util.Set;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public final class TreeAnimationHandler {
    private final TimberZ plugin;
    private final Random random = new Random();

    public TreeAnimationHandler(TimberZ plugin) {
        this.plugin = plugin;
    }

    public void animateTreeFelling(final Player player, Set<Block> treeBlocks) {
        final ArrayList<Block> orderedBlocks = new ArrayList<Block>(treeBlocks);
        orderedBlocks.sort(Comparator.comparingInt(Block::getY));
        final Vector direction = player.getLocation().getDirection().normalize();
        this.playAxeSwingEffect(player);
        int delay = 0;
        int baseIncrement = 1;
        for (int i = 0; i < orderedBlocks.size(); ++i) {
            final Block block = (Block)orderedBlocks.get(i);
            int dynamicIncrement = Math.max(1, baseIncrement - i / 10);
            new BukkitRunnable(){

                public void run() {
                    TreeAnimationHandler.this.createBreakEffect(player, block, direction);
                    Material blockType = block.getType();
                    block.breakNaturally(player.getInventory().getItemInMainHand());
                    if (TreeAnimationHandler.this.random.nextInt(5) == 0) {
                        TreeAnimationHandler.this.spawnWoodChips(block.getLocation().add(0.5, 0.5, 0.5), direction);
                    }
                }
            }.runTaskLater((Plugin)this.plugin, (long)delay);
            delay += dynamicIncrement;
        }
        new BukkitRunnable(this){

            public void run() {
                World world = player.getWorld();
                Location lastBlockLoc = orderedBlocks.isEmpty() ? player.getLocation() : ((Block)orderedBlocks.get(orderedBlocks.size() - 1)).getLocation();
                world.playSound(lastBlockLoc, Sound.BLOCK_WOOD_FALL, 1.0f, 0.8f);
                world.spawnParticle(Particle.CLOUD, lastBlockLoc.add(0.5, 0.5, 0.5), 20, 1.5, 1.0, 1.5, 0.05);
            }
        }.runTaskLater((Plugin)this.plugin, (long)(delay + 5));
    }

    private void createBreakEffect(Player player, Block block, Vector direction) {
        World world = block.getWorld();
        Location loc = block.getLocation().add(0.5, 0.5, 0.5);
        world.spawnParticle(Particle.BLOCK, loc, 15, 0.4, 0.4, 0.4, 0.1, (Object)block.getBlockData());
        Vector particleDir = direction.clone().multiply(0.15);
        world.spawnParticle(Particle.SMOKE, loc, 8, 0.3, 0.3, 0.3, 0.02);
        if (block.getType().name().contains("LEAVES")) {
            world.spawnParticle(Particle.COMPOSTER, loc, 10, 0.5, 0.5, 0.5, 0.1);
        }
        float pitch = 0.8f + this.random.nextFloat() * 0.4f;
        world.playSound(loc, Sound.BLOCK_WOOD_BREAK, 0.8f, pitch);
        if (this.random.nextInt(4) == 0) {
            world.playSound(loc, Sound.BLOCK_WOOD_HIT, 0.5f, 0.6f);
        }
    }

    private void spawnWoodChips(Location location, Vector direction) {
        World world = location.getWorld();
        Vector chipVelocity = direction.clone().add(new Vector((double)this.random.nextFloat() * 0.4 - 0.2, (double)this.random.nextFloat() * 0.2, (double)this.random.nextFloat() * 0.4 - 0.2)).multiply(0.3);
        for (int i = 0; i < 3; ++i) {
            Vector randomOffset = new Vector(this.random.nextDouble() * 0.4 - 0.2, this.random.nextDouble() * 0.4 - 0.2, this.random.nextDouble() * 0.4 - 0.2);
            Location chipLoc = location.clone().add(randomOffset);
            world.spawnParticle(Particle.DUST, chipLoc, 2, 0.1, 0.1, 0.1, 0.0, (Object)new Particle.DustOptions(Color.fromRGB((int)139, (int)69, (int)19), 1.0f));
        }
    }

    private void playAxeSwingEffect(Player player) {
        World world = player.getWorld();
        Location handLoc = player.getEyeLocation().add(player.getLocation().getDirection().multiply(1.0));
        world.spawnParticle(Particle.SWEEP_ATTACK, handLoc, 1, 0.0, 0.0, 0.0, 0.0);
        world.playSound(player.getLocation(), Sound.ENTITY_PLAYER_ATTACK_SWEEP, 0.8f, 1.2f);
        world.spawnParticle(Particle.CRIT, handLoc, 10, 0.3, 0.3, 0.3, 0.2);
    }
}

