/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.timberz.listener;

import com.zetaplugins.timberz.TimberZ;
import com.zetaplugins.timberz.service.MaterialTypeChecks;
import com.zetaplugins.timberz.service.MessageService;
import com.zetaplugins.timberz.service.PlayerStateService;
import com.zetaplugins.timberz.service.TreeFellerService;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public final class TreeBreakListener
implements Listener {
    private final TimberZ plugin;
    private final TreeFellerService TreeFellerService;
    private final PlayerStateService playerStateService;

    public TreeBreakListener(TimberZ plugin) {
        this.plugin = plugin;
        this.TreeFellerService = plugin.getTreeFellerService();
        this.playerStateService = plugin.getPlayerStateService();
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent event) {
        Set<Block> treeBlocks;
        ItemStack handItem;
        Block brokenBlock = event.getBlock();
        Material blockType = brokenBlock.getType();
        Player player = event.getPlayer();
        if (player.isSneaking()) {
            return;
        }
        if (!this.playerStateService.isAllowedToTimber(player)) {
            return;
        }
        if (this.plugin.getTreeDetectionService().containsLog(blockType) && MaterialTypeChecks.isValidAxe(handItem = player.getInventory().getItemInMainHand(), this.plugin) && !(treeBlocks = this.plugin.getTreeDetectionService().identifyTreeStructure(brokenBlock)).isEmpty()) {
            int logsCount = treeBlocks.size();
            int durabilityCost = this.calculateDurabilityCost(logsCount);
            if (this.plugin.hasAuraSkills()) {
                this.plugin.getAuraSkillsManager().giveAuraSkillsXP(player, treeBlocks);
            }
            if (this.hasEnoughDurability(handItem, durabilityCost)) {
                event.setCancelled(true);
                this.TreeFellerService.fellTree(player, brokenBlock, treeBlocks, handItem, durabilityCost);
            } else {
                player.sendMessage(this.plugin.getMessageService().getAndFormatMsg(false, "notEnoughDurability", "&cYou don't have enough durability left on your axe!", new MessageService.Replaceable[0]));
            }
        }
    }

    private int calculateDurabilityCost(int logsCount) {
        double multiplier = this.plugin.getConfig().getDouble("durabilityMultiplier", 1.0);
        return (int)Math.ceil((double)logsCount * multiplier);
    }

    private boolean hasEnoughDurability(ItemStack tool, int durabilityCost) {
        short maxDurability = tool.getType().getMaxDurability();
        if (maxDurability <= 0) {
            return true;
        }
        ItemMeta itemMeta = tool.getItemMeta();
        if (itemMeta instanceof Damageable) {
            int minDurability;
            Damageable meta = (Damageable)itemMeta;
            int currentDamage = meta.getDamage();
            int remainingDurability = maxDurability - currentDamage;
            return remainingDurability - durabilityCost >= (minDurability = this.plugin.getConfig().getInt("minDurability", 10));
        }
        return !this.plugin.getConfig().getBoolean("requireAxeMaterial");
    }
}

