/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.timberz.service;

import com.zetaplugins.timberz.TimberZ;
import com.zetaplugins.timberz.handler.SaplingReplanter;
import com.zetaplugins.timberz.handler.TreeAnimationHandler;
import com.zetaplugins.timberz.service.MaterialTypeChecks;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class TreeFellerService {
    private final TimberZ plugin;
    private final TreeAnimationHandler animationHandler;
    private final SaplingReplanter saplingReplanter;
    private final Random random = new Random();

    public TreeFellerService(TimberZ plugin) {
        this.plugin = plugin;
        this.animationHandler = new TreeAnimationHandler(plugin);
        this.saplingReplanter = new SaplingReplanter(plugin);
    }

    public void fellTree(Player player, Block sourceBlock, Set<Block> treeBlocks, ItemStack tool, int durabilityCost) {
        Material logType = sourceBlock.getType();
        Material leafType = this.plugin.getTreeDetectionService().getLeafType(logType);
        SaplingReplanter.TreeInfo treeInfo = this.saplingReplanter.analyzeTreeType(sourceBlock, treeBlocks);
        Set<Block> leafBlocks = this.collectLeaves(treeBlocks, leafType);
        this.breakTreeWithAnimation(player, treeBlocks, tool, durabilityCost);
        if (!leafBlocks.isEmpty() && this.plugin.getConfig().getBoolean("instantLeafDecay")) {
            this.scheduleLeafDecay(leafBlocks);
        }
        boolean shouldReplant = this.plugin.getConfig().getBoolean("replant");
        if (treeInfo != null && shouldReplant) {
            this.saplingReplanter.scheduleSaplingReplant(treeInfo);
        }
    }

    private double distanceBetween(Block block1, Block block2) {
        double dx = block1.getX() - block2.getX();
        double dy = block1.getY() - block2.getY();
        double dz = block1.getZ() - block2.getZ();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private Set<Block> collectLeaves(Set<Block> treeBlocks, Material leafType) {
        HashSet<Block> leafBlocks = new HashSet<Block>();
        HashSet<Block> checkedBlocks = new HashSet<Block>();
        HashSet<Block> otherTreeLogs = new HashSet<Block>();
        int SEARCH_RADIUS = this.plugin.getConfig().getInt("leavesSearchRadius", 4);
        for (Block log : treeBlocks) {
            for (int x = -SEARCH_RADIUS; x <= SEARCH_RADIUS; ++x) {
                for (int y = -SEARCH_RADIUS; y <= SEARCH_RADIUS; ++y) {
                    for (int z = -SEARCH_RADIUS; z <= SEARCH_RADIUS; ++z) {
                        Block checkBlock = log.getRelative(x, y, z);
                        if (checkedBlocks.contains(checkBlock)) continue;
                        checkedBlocks.add(checkBlock);
                        if (checkBlock.getType() == leafType) {
                            leafBlocks.add(checkBlock);
                            continue;
                        }
                        if (!this.plugin.getTreeDetectionService().containsLog(checkBlock.getType()) || treeBlocks.contains(checkBlock)) continue;
                        otherTreeLogs.add(checkBlock);
                    }
                }
            }
        }
        if (!otherTreeLogs.isEmpty()) {
            HashSet<Block> filteredLeaves = new HashSet<Block>();
            for (Block leaf : leafBlocks) {
                double minDistToOurTree = Double.MAX_VALUE;
                for (Block ourLog : treeBlocks) {
                    double dist = this.distanceBetween(leaf, ourLog);
                    if (!(dist < minDistToOurTree)) continue;
                    minDistToOurTree = dist;
                }
                double minDistToOtherTree = Double.MAX_VALUE;
                for (Block otherLog : otherTreeLogs) {
                    double dist = this.distanceBetween(leaf, otherLog);
                    if (!(dist < minDistToOtherTree)) continue;
                    minDistToOtherTree = dist;
                }
                if (!(minDistToOurTree <= minDistToOtherTree * 1.2)) continue;
                filteredLeaves.add(leaf);
            }
            return filteredLeaves;
        }
        return leafBlocks;
    }

    private void scheduleLeafDecay(Set<Block> leafBlocks) {
        ArrayList<Block> sortedLeaves = new ArrayList<Block>(leafBlocks);
        sortedLeaves.sort(Comparator.comparingInt(Block::getY));
        for (final Block leaf : sortedLeaves) {
            new BukkitRunnable(){

                public void run() {
                    if (MaterialTypeChecks.isLeafBlock(leaf.getType(), TreeFellerService.this.plugin.getConfigService().getBlocksConfig())) {
                        leaf.getWorld().spawnParticle(Particle.BLOCK, leaf.getLocation().add(0.5, 0.5, 0.5), 5, 0.3, 0.3, 0.3, 0.05, (Object)leaf.getBlockData());
                        float pitch = 0.8f + TreeFellerService.this.random.nextFloat() * 0.4f;
                        leaf.getWorld().playSound(leaf.getLocation(), Sound.BLOCK_GRASS_BREAK, 0.6f, pitch);
                        leaf.breakNaturally();
                    }
                }
            }.runTaskLater((Plugin)this.plugin, (long)(5 + this.random.nextInt(40)));
        }
    }

    private boolean isConnectedToLog(Block leafBlock) {
        for (int x = -4; x <= 4; ++x) {
            for (int y = -4; y <= 4; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    if (Math.abs(x) + Math.abs(y) + Math.abs(z) > 4) continue;
                    Block nearbyBlock = leafBlock.getRelative(x, y, z);
                    Material blockType = nearbyBlock.getType();
                    if (!this.plugin.getTreeDetectionService().containsLog(blockType)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void breakTreeWithAnimation(Player player, Set<Block> treeBlocks, ItemStack tool, int durabilityCost) {
        this.applyToolDamage(tool, durabilityCost);
        this.animationHandler.animateTreeFelling(player, treeBlocks);
    }

    private void applyToolDamage(ItemStack tool, int durabilityCost) {
        if (tool.getItemMeta() instanceof Damageable) {
            Damageable meta = (Damageable)tool.getItemMeta();
            int newDamage = meta.getDamage() + durabilityCost;
            meta.setDamage(newDamage);
            tool.setItemMeta((ItemMeta)meta);
        }
    }
}

