/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.timberz.service.auraskills;

import com.zetaplugins.timberz.TimberZ;
import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import dev.aurelium.auraskills.api.source.XpSource;
import dev.aurelium.auraskills.api.user.SkillsUser;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public final class AuraSkillsManager {
    private final TimberZ plugin;
    private final AuraSkillsApi auraSkillsApi = AuraSkillsApi.get();

    public AuraSkillsManager(TimberZ plugin) {
        this.plugin = plugin;
    }

    public void giveAuraSkillsXP(Player player, Set<Block> blocksBroken) {
        if (this.auraSkillsApi == null) {
            this.plugin.getLogger().warning("AuraSkills API is not available. Cannot give XP.");
            return;
        }
        SkillsUser skillsUser = this.auraSkillsApi.getUser(player.getUniqueId());
        Map<String, Double> xpSources = Skills.FORAGING.getSources().stream().filter(source -> source.getType().toString().equals("BLOCK")).collect(Collectors.toMap(XpSource::name, XpSource::getXp));
        double totalXP = 0.0;
        for (Block block : blocksBroken) {
            String blockType = block.getType().toString();
            if (!xpSources.containsKey(blockType)) continue;
            totalXP += xpSources.get(blockType).doubleValue();
        }
        double auraSkillsXPMultiplier = this.plugin.getConfig().getDouble("auraSkillsXPMultiplier", 1.0);
        skillsUser.addSkillXp((Skill)Skills.FORAGING, totalXP * auraSkillsXPMultiplier);
    }
}

