/*
 * Decompiled with CFR 0.152.
 */
package com.realgecko.xpfromharvest;

import com.realgecko.xpfromharvest.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class SimpleHarvestHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void handleRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntity() == null || event.getLevel().isClientSide()) {
            return;
        }
        Level world = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (Config.cropList.contains(state.toString())) {
            this.handleHarvest(block, world, pos, state, event, world.random);
        }
    }

    void handleHarvest(Block block, Level world, BlockPos pos, BlockState state, PlayerInteractEvent.RightClickBlock event, RandomSource rand) {
        List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, null);
        ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
        boolean foundSeed = false;
        for (ItemStack stack : drops) {
            if (!(stack.getItem() instanceof BlockItem) || foundSeed || ((BlockItem)stack.getItem()).getBlock() != block) continue;
            stack.shrink(1);
            if (stack.getCount() == 0) {
                toRemove.add(stack);
            }
            foundSeed = true;
        }
        drops.removeAll(toRemove);
        for (ItemStack stack : drops) {
            ItemEntity entityItem = new ItemEntity(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), stack);
            world.addFreshEntity((Entity)entityItem);
        }
        if (rand.nextInt(100) + 1 <= Config.chance) {
            block.popExperience((ServerLevel)event.getLevel(), event.getPos(), Config.xpAmount);
        }
        world.setBlockAndUpdate(pos, block.defaultBlockState());
    }
}

