/*
 * Decompiled with CFR 0.152.
 */
package vanilla_expanded.mcreator.block;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import vanilla_expanded.mcreator.init.VanillaExpandedModBlocks;
import vanilla_expanded.mcreator.procedures.RainbowBedOnBlockRightClickedProcedure;

public class RainbowBedBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<BedPart> BED_PART = BlockStateProperties.BED_PART;

    public RainbowBedBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.COLOR_YELLOW).sound(SoundType.WOOD).strength(4.0f, 25.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(BED_PART, (Comparable)((BedPart)BED_PART.getValue("foot").get())));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)RainbowBedBlock.box((double)13.0, (double)0.0, (double)-16.0, (double)16.0, (double)3.0, (double)-13.0), (VoxelShape[])new VoxelShape[]{RainbowBedBlock.box((double)0.0, (double)0.0, (double)-16.0, (double)3.0, (double)3.0, (double)-13.0), RainbowBedBlock.box((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0), RainbowBedBlock.box((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0), RainbowBedBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), RainbowBedBlock.box((double)0.0, (double)3.0, (double)-16.0, (double)16.0, (double)9.0, (double)0.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)RainbowBedBlock.box((double)0.0, (double)0.0, (double)29.0, (double)3.0, (double)3.0, (double)32.0), (VoxelShape[])new VoxelShape[]{RainbowBedBlock.box((double)13.0, (double)0.0, (double)29.0, (double)16.0, (double)3.0, (double)32.0), RainbowBedBlock.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0), RainbowBedBlock.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0), RainbowBedBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), RainbowBedBlock.box((double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)9.0, (double)32.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)RainbowBedBlock.box((double)-16.0, (double)0.0, (double)0.0, (double)-13.0, (double)3.0, (double)3.0), (VoxelShape[])new VoxelShape[]{RainbowBedBlock.box((double)-16.0, (double)0.0, (double)13.0, (double)-13.0, (double)3.0, (double)16.0), RainbowBedBlock.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0), RainbowBedBlock.box((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0), RainbowBedBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), RainbowBedBlock.box((double)-16.0, (double)3.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)RainbowBedBlock.box((double)29.0, (double)0.0, (double)13.0, (double)32.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{RainbowBedBlock.box((double)29.0, (double)0.0, (double)0.0, (double)32.0, (double)3.0, (double)3.0), RainbowBedBlock.box((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0), RainbowBedBlock.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0), RainbowBedBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), RainbowBedBlock.box((double)16.0, (double)3.0, (double)0.0, (double)32.0, (double)9.0, (double)16.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, BED_PART});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(BED_PART, (Comparable)((BedPart)BED_PART.getValue("foot").get()));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }

    public InteractionResult useWithoutItem(BlockState blockstate, Level world, BlockPos pos, Player entity, BlockHitResult hit) {
        super.useWithoutItem(blockstate, world, pos, entity, hit);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        double hitX = hit.getLocation().x;
        double hitY = hit.getLocation().y;
        double hitZ = hit.getLocation().z;
        Direction direction = hit.getDirection();
        RainbowBedOnBlockRightClickedProcedure.execute((Entity)entity);
        return InteractionResult.SUCCESS;
    }

    public static class Item
    extends BlockItem {
        public Item(Item.Properties properties) {
            super((Block)VanillaExpandedModBlocks.RAINBOW_BED.get(), properties);
        }

        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> componentConsumer, TooltipFlag flag) {
            super.appendHoverText(itemstack, context, tooltipDisplay, componentConsumer, flag);
            componentConsumer.accept((Component)Component.translatable((String)"block.vanilla_expanded.rainbow_bed.description_0"));
            componentConsumer.accept((Component)Component.translatable((String)"block.vanilla_expanded.rainbow_bed.description_1"));
            componentConsumer.accept((Component)Component.translatable((String)"block.vanilla_expanded.rainbow_bed.description_2"));
        }
    }
}

