/*
 * Decompiled with CFR 0.152.
 */
package vanilla_expanded.mcreator.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RainbowBedHeadBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<BedPart> BED_PART = BlockStateProperties.BED_PART;

    public RainbowBedHeadBlock(BlockBehaviour.Properties properties) {
        super(properties.sound(SoundType.WOOD).strength(4.0f, 25.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue(BED_PART, (Comparable)((BedPart)BED_PART.getValue("head").get())));
    }

    public boolean propagatesSkylightDown(BlockState state) {
        return true;
    }

    public int getLightBlock(BlockState state) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue(FACING)) {
            default -> Shapes.or((VoxelShape)RainbowBedHeadBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), (VoxelShape[])new VoxelShape[]{RainbowBedHeadBlock.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0), RainbowBedHeadBlock.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)RainbowBedHeadBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), (VoxelShape[])new VoxelShape[]{RainbowBedHeadBlock.box((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0), RainbowBedHeadBlock.box((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)RainbowBedHeadBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), (VoxelShape[])new VoxelShape[]{RainbowBedHeadBlock.box((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)3.0, (double)16.0), RainbowBedHeadBlock.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)3.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)RainbowBedHeadBlock.box((double)0.0, (double)3.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0), (VoxelShape[])new VoxelShape[]{RainbowBedHeadBlock.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)3.0), RainbowBedHeadBlock.box((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)3.0, (double)16.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, BED_PART});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue(FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue(BED_PART, (Comparable)((BedPart)BED_PART.getValue("head").get()));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue(FACING, (Comparable)rot.rotate((Direction)state.getValue(FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue(FACING)));
    }
}

