/*
 * Decompiled with CFR 0.152.
 */
package vanilla_expanded.mcreator.procedures;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import vanilla_expanded.mcreator.VanillaExpandedMod;
import vanilla_expanded.mcreator.init.VanillaExpandedModItems;

public class SoulEntitySwingsItemProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null) {
            return;
        }
        if (SoulEntitySwingsItemProcedure.getEntityGameType(entity) == GameType.CREATIVE) {
            Player _player;
            Level _level;
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)(x + 0.5), (double)(y + 1.0), (double)(z + 0.5)), (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"particle.soul_escape")), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(x + 0.5, y + 1.0, z + 0.5, (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"particle.soul_escape")), SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)ParticleTypes.SOUL, x + 0.5, y + 1.0, z + 0.5, 1, 0.0, 1.0, 0.0, 0.05);
            }
            VanillaExpandedMod.queueServerWork(20, () -> {
                if (world instanceof ServerLevel) {
                    ServerLevel _level = (ServerLevel)world;
                    ItemEntity entityToSpawn = new ItemEntity((Level)_level, x + 0.5, y + 1.0, z + 0.5, new ItemStack((ItemLike)Items.GOLD_NUGGET));
                    entityToSpawn.setPickUpDelay(10);
                    _level.addFreshEntity((Entity)entityToSpawn);
                }
            });
            if (entity instanceof Player && !(_player = (Player)entity).level().isClientSide()) {
                _player.displayClientMessage((Component)Component.literal((String)"Successfully freed a soul!"), true);
            }
        } else {
            Level _level;
            Player _player;
            if (entity instanceof Player) {
                _player = (Player)entity;
                ItemStack _stktoremove = new ItemStack((ItemLike)VanillaExpandedModItems.SOUL.get());
                _player.getInventory().clearOrCountMatchingItems(p -> _stktoremove.getItem() == p.getItem(), 1, (Container)_player.inventoryMenu.getCraftSlots());
            }
            entity.hurt(new DamageSource(world.holderOrThrow(DamageTypes.MAGIC)), 2.0f);
            VanillaExpandedMod.queueServerWork(20, () -> {
                if (world instanceof ServerLevel) {
                    ServerLevel _level = (ServerLevel)world;
                    ItemEntity entityToSpawn = new ItemEntity((Level)_level, x + 0.5, y + 1.0, z + 0.5, new ItemStack((ItemLike)Items.GOLD_NUGGET));
                    entityToSpawn.setPickUpDelay(10);
                    _level.addFreshEntity((Entity)entityToSpawn);
                }
            });
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)(x + 0.5), (double)(y + 1.0), (double)(z + 0.5)), (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"particle.soul_escape")), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(x + 0.5, y + 1.0, z + 0.5, (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(ResourceLocation.parse((String)"particle.soul_escape")), SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)ParticleTypes.SOUL, x + 0.5, y + 1.0, z + 0.5, 1, 0.0, 1.0, 0.0, 0.05);
            }
            if (entity instanceof Player && !(_player = (Player)entity).level().isClientSide()) {
                _player.displayClientMessage((Component)Component.literal((String)"Successfully freed a soul!"), true);
            }
        }
    }

    private static GameType getEntityGameType(Entity entity) {
        PlayerInfo playerInfo;
        Player player;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.gameMode.getGameModeForPlayer();
        }
        if (entity instanceof Player && (player = (Player)entity).level().isClientSide() && (playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(player.getGameProfile().getId())) != null) {
            return playerInfo.getGameMode();
        }
        return null;
    }
}

