/*
 * Decompiled with CFR 0.152.
 */
package vanilla_expanded.mcreator.procedures;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import vanilla_expanded.mcreator.init.VanillaExpandedModItems;

public class SoulLivingEntityIsHitWithItemProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, Entity sourceentity) {
        if (entity == null || sourceentity == null) {
            return;
        }
        if (SoulLivingEntityIsHitWithItemProcedure.getEntityGameType(sourceentity) == GameType.CREATIVE) {
            Level _level;
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)(y + 1.0), (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"particle.soul_escape")), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(x, y + 1.0, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"particle.soul_escape")), SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)ParticleTypes.SOUL, x, y + 1.0, z, 1, 0.5, 1.0, 0.5, 0.05);
            }
            entity.hurt(new DamageSource(world.holderOrThrow(DamageTypes.MAGIC)), 2.0f);
        } else {
            Level _level;
            if (world instanceof Level) {
                _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)(y + 1.0), (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"particle.soul_escape")), SoundSource.PLAYERS, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(x, y + 1.0, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"particle.soul_escape")), SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
            }
            if (world instanceof ServerLevel) {
                _level = (ServerLevel)world;
                _level.sendParticles((ParticleOptions)ParticleTypes.SOUL, x, y + 1.0, z, 1, 0.5, 1.0, 0.5, 0.05);
            }
            entity.hurt(new DamageSource(world.holderOrThrow(DamageTypes.MAGIC)), 2.0f);
            sourceentity.hurt(new DamageSource(world.holderOrThrow(DamageTypes.MAGIC)), 2.0f);
            if (sourceentity instanceof Player) {
                Player _player = (Player)sourceentity;
                ItemStack _stktoremove = new ItemStack((ItemLike)VanillaExpandedModItems.SOUL.get());
                _player.getInventory().clearOrCountMatchingItems(p -> _stktoremove.getItem() == p.getItem(), 1, (Container)_player.inventoryMenu.getCraftSlots());
            }
        }
    }

    private static GameType getEntityGameType(Entity entity) {
        PlayerInfo playerInfo;
        Player player;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.gameMode.getGameModeForPlayer();
        }
        if (entity instanceof Player && (player = (Player)entity).level().isClientSide() && (playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(player.getGameProfile().getId())) != null) {
            return playerInfo.getGameMode();
        }
        return null;
    }
}

