/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.bukkit.feature.features;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bukkit.GameMode;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.sayandev.sayanvanish.api.feature.RegisteredFeature;
import org.sayandev.sayanvanish.bukkit.api.BukkitUser;
import org.sayandev.sayanvanish.bukkit.api.SayanVanishBukkitAPI;
import org.sayandev.sayanvanish.bukkit.api.event.BukkitUserUnVanishEvent;
import org.sayandev.sayanvanish.bukkit.api.event.BukkitUserVanishEvent;
import org.sayandev.sayanvanish.bukkit.feature.ListenedFeature;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.NotNull;
import org.sayandev.sayanvanish.lib.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.sayandev.sayanvanish.lib.spongepowered.configurate.objectmapping.meta.Comment;
import org.sayandev.sayanvanish.lib.stickynote.bukkit.StickyNote;

@RegisteredFeature
@ConfigSerializable
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B/\u0012\b\b\u0003\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0003J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020 H\u0003J\u0010\u0010!\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\"H\u0007J\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020$H\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00030\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006%"}, d2={"Lorg/sayandev/sayanvanish/bukkit/feature/features/FeatureGameMode;", "Lorg/sayandev/sayanvanish/bukkit/feature/ListenedFeature;", "fallbackMode", "Lorg/bukkit/GameMode;", "checkGameModeChange", "", "checkToggleSneak", "timeWindowTicks", "", "<init>", "(Lorg/bukkit/GameMode;ZZJ)V", "getFallbackMode", "()Lorg/bukkit/GameMode;", "getCheckGameModeChange", "()Z", "getCheckToggleSneak", "getTimeWindowTicks", "()J", "sneakMap", "", "Lorg/bukkit/entity/Player;", "getSneakMap", "()Ljava/util/Map;", "sneakList", "", "getSneakList", "()Ljava/util/List;", "onToggleSneak", "", "event", "Lorg/bukkit/event/player/PlayerToggleSneakEvent;", "onGameModeChange", "Lorg/bukkit/event/player/PlayerGameModeChangeEvent;", "onVanish", "Lorg/sayandev/sayanvanish/bukkit/api/event/BukkitUserVanishEvent;", "onUnVanish", "Lorg/sayandev/sayanvanish/bukkit/api/event/BukkitUserUnVanishEvent;", "sayanvanish-bukkit"})
public final class FeatureGameMode
extends ListenedFeature {
    @NotNull
    private final GameMode fallbackMode;
    private final boolean checkGameModeChange;
    private final boolean checkToggleSneak;
    private final long timeWindowTicks;
    @NotNull
    private final transient Map<Player, GameMode> sneakMap;
    @NotNull
    private final transient List<Player> sneakList;

    public FeatureGameMode(@Comment(value="The fallback gamemode when the player is not vanished and doesn't have in-memory gamemode.") @NotNull GameMode fallbackMode, @Comment(value="Update gamemode history on gamemode change event.") boolean checkGameModeChange, @Comment(value="Change gamemode to spectator on double-sneak") boolean checkToggleSneak, long timeWindowTicks) {
        Intrinsics.checkNotNullParameter((Object)fallbackMode, (String)"fallbackMode");
        super("gamemode", false, null, null, false, 30, null);
        this.fallbackMode = fallbackMode;
        this.checkGameModeChange = checkGameModeChange;
        this.checkToggleSneak = checkToggleSneak;
        this.timeWindowTicks = timeWindowTicks;
        this.sneakMap = new LinkedHashMap();
        this.sneakList = new ArrayList();
    }

    public /* synthetic */ FeatureGameMode(GameMode gameMode, boolean bl, boolean bl2, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            gameMode = GameMode.SURVIVAL;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        if ((n & 8) != 0) {
            l = 8L;
        }
        this(gameMode, bl, bl2, l);
    }

    @NotNull
    public final GameMode getFallbackMode() {
        return this.fallbackMode;
    }

    public final boolean getCheckGameModeChange() {
        return this.checkGameModeChange;
    }

    public final boolean getCheckToggleSneak() {
        return this.checkToggleSneak;
    }

    public final long getTimeWindowTicks() {
        return this.timeWindowTicks;
    }

    @NotNull
    public final Map<Player, GameMode> getSneakMap() {
        return this.sneakMap;
    }

    @NotNull
    public final List<Player> getSneakList() {
        return this.sneakList;
    }

    @EventHandler
    private final void onToggleSneak(PlayerToggleSneakEvent event) {
        if (!this.checkToggleSneak) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        BukkitUser bukkitUser = SayanVanishBukkitAPI.Companion.user((OfflinePlayer)player2);
        if (bukkitUser == null) {
            return;
        }
        BukkitUser user2 = bukkitUser;
        if (!(player2.isSneaking() && user2.isVanished() && this.isActive(user2))) {
            return;
        }
        if (this.sneakList.contains(player2)) {
            if (player2.getGameMode() == GameMode.SPECTATOR) {
                boolean allowFlight = player2.getAllowFlight();
                boolean isFlying = player2.isFlying();
                GameMode gameMode = this.sneakMap.get(player2);
                if (gameMode == null) {
                    gameMode = this.fallbackMode;
                }
                player2.setGameMode(gameMode);
                player2.setAllowFlight(allowFlight);
                player2.setFlying(isFlying);
            } else {
                this.sneakMap.put(player2, player2.getGameMode());
                player2.setGameMode(GameMode.SPECTATOR);
            }
        } else {
            if (player2.getGameMode() != GameMode.SPECTATOR) {
                this.sneakMap.put(player2, player2.getGameMode());
            }
            this.sneakList.add(player2);
            StickyNote.runSync(() -> FeatureGameMode.onToggleSneak$lambda$0(this, player2), (long)this.timeWindowTicks);
        }
    }

    @EventHandler
    private final void onGameModeChange(PlayerGameModeChangeEvent event) {
        if (!this.checkGameModeChange) {
            return;
        }
        Player player = event.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)player, (String)"getPlayer(...)");
        Player player2 = player;
        BukkitUser bukkitUser = SayanVanishBukkitAPI.Companion.user((OfflinePlayer)player2);
        if (!(bukkitUser != null ? !bukkitUser.isVanished() : false)) {
            return;
        }
        this.sneakMap.put(player2, event.getNewGameMode());
    }

    @EventHandler
    public final void onVanish(@NotNull BukkitUserVanishEvent event) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        BukkitUser user2 = event.getUser();
        Player player = user2.player();
        if (player == null) {
            return;
        }
        Player player2 = player;
        if (player2.getGameMode() == GameMode.SPECTATOR) {
            return;
        }
        boolean allowFlight = player2.getAllowFlight();
        boolean isFlying = player2.isFlying();
        this.sneakMap.put(player2, player2.getGameMode());
        player2.setAllowFlight(allowFlight);
        player2.setFlying(isFlying);
    }

    @EventHandler
    private final void onUnVanish(BukkitUserUnVanishEvent event) {
        BukkitUser user2 = event.getUser();
        Player player = user2.player();
        if (player == null) {
            return;
        }
        Player player2 = player;
        GameMode gameMode = this.sneakMap.get(player2);
        if (gameMode == null) {
            gameMode = this.fallbackMode;
        }
        player2.setGameMode(gameMode);
        if (player2.getGameMode() == GameMode.SPECTATOR || this.sneakMap.get(player2) == GameMode.SPECTATOR) {
            return;
        }
        boolean isFlying = player2.isFlying();
        boolean allowFlight = player2.getAllowFlight();
        player2.setAllowFlight(allowFlight);
        player2.setFlying(isFlying);
    }

    private static final void onToggleSneak$lambda$0(FeatureGameMode this$0, Player $player) {
        this$0.sneakList.remove($player);
    }

    public FeatureGameMode() {
        this(null, false, false, 0L, 15, null);
    }
}

