/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.api.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/sayandev/sayanvanish/api/utils/DownloadUtils;", "", "<init>", "()V", "download", "Ljava/util/concurrent/CompletableFuture;", "", "url", "", "destination", "Ljava/io/File;", "sayanvanish-api"})
public final class DownloadUtils {
    @NotNull
    public static final DownloadUtils INSTANCE = new DownloadUtils();

    private DownloadUtils() {
    }

    @NotNull
    public final CompletableFuture<Boolean> download(@NotNull String url, @NotNull File destination) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        URL url2 = new URL(url);
        URLConnection uRLConnection = url2.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        if (connection.getResponseCode() == 200) {
            BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
            FileOutputStream outputStream = new FileOutputStream(destination);
            byte[] buffer = new byte[1024];
            int bytesRead = inputStream.read(buffer);
            while (bytesRead != -1) {
                outputStream.write(buffer, 0, bytesRead);
                bytesRead = inputStream.read(buffer);
            }
            outputStream.close();
            inputStream.close();
            v1 = future.complete(true);
        } else {
            v1 = future.complete(false);
        }
        connection.disconnect();
        return future;
    }
}

