/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.api.utils;

import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/sayandev/sayanvanish/api/utils/Paste;", "", "language", "", "content", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getLanguage", "()Ljava/lang/String;", "getContent", "()Ljava/util/List;", "post", "Ljava/util/concurrent/CompletableFuture;", "Companion", "sayanvanish-api"})
@SourceDebugExtension(value={"SMAP\nPaste.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Paste.kt\norg/sayandev/sayanvanish/api/utils/Paste\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class Paste {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String language;
    @NotNull
    private final List<String> content;
    @NotNull
    private static final String BASE_URL = "https://api.pastes.dev";
    @NotNull
    private static final String POST_URL = "https://api.pastes.dev/post";
    @NotNull
    private static final String USER_AGENT = "Mozilla/5.0";
    @NotNull
    public static final String PASTE_URL = "https://pastes.dev";

    public Paste(@NotNull String language, @NotNull List<String> content) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        this.language = language;
        this.content = content;
    }

    @NotNull
    public final String getLanguage() {
        return this.language;
    }

    @NotNull
    public final List<String> getContent() {
        return this.content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CompletableFuture<String> post() {
        Object object;
        CompletableFuture<String> future = new CompletableFuture<String>();
        URL url = new URL(POST_URL);
        URLConnection uRLConnection = url.openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setRequestMethod("POST");
        connection.setRequestProperty("User-Agent", USER_AGENT);
        connection.setRequestProperty("Content-Type", "text/" + this.language);
        connection.setDoOutput(true);
        connection.setConnectTimeout(10000);
        Closeable closeable = connection.getOutputStream();
        Object object2 = null;
        try {
            OutputStream os = (OutputStream)closeable;
            boolean bl = false;
            String string = CollectionsKt.joinToString$default((Iterable)this.content, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            byte[] byArray = string.getBytes(charset2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byte[] byArray2 = new ByteArrayInputStream(byArray).readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"readAllBytes(...)");
            byte[] input = byArray2;
            os.write(input, 0, input.length);
            object = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            object2 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
        }
        int responseCode = connection.getResponseCode();
        switch (responseCode) {
            case 200: 
            case 201: {
                object2 = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
                object = null;
                try {
                    BufferedReader br = (BufferedReader)object2;
                    boolean bl = false;
                    String inputLine = null;
                    StringBuilder response = new StringBuilder();
                    while (true) {
                        String string;
                        String it = string = br.readLine();
                        boolean bl2 = false;
                        inputLine = it;
                        if (string == null) break;
                        response.append(inputLine);
                    }
                    String key = JsonParser.parseString((String)response.toString()).getAsJsonObject().get("key").getAsString();
                    future.complete(key);
                    CompletableFuture<String> completableFuture = future;
                    return completableFuture;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                }
            }
        }
        throw new IOException("Failed to upload content, HTTP response code: " + responseCode);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/sayandev/sayanvanish/api/utils/Paste$Companion;", "", "<init>", "()V", "BASE_URL", "", "POST_URL", "USER_AGENT", "PASTE_URL", "sayanvanish-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

