/*
 * Decompiled with CFR 0.152.
 */
package org.sayandev.sayanvanish.bukkit.feature.features;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.sayandev.sayanvanish.api.feature.RegisteredFeature;
import org.sayandev.sayanvanish.bukkit.api.BukkitUser;
import org.sayandev.sayanvanish.bukkit.api.event.BukkitUserUnVanishEvent;
import org.sayandev.sayanvanish.bukkit.api.event.BukkitUserVanishEvent;
import org.sayandev.sayanvanish.bukkit.feature.ListenedFeature;
import org.sayandev.sayanvanish.bukkit.feature.features.PotionEffectData;
import org.sayandev.sayanvanish.bukkit.feature.features.PotionEffectTypeSerializer;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.NotNull;
import org.sayandev.sayanvanish.lib.jetbrains.annotations.Nullable;
import org.sayandev.sayanvanish.lib.spongepowered.configurate.objectmapping.ConfigSerializable;
import org.sayandev.sayanvanish.lib.spongepowered.configurate.objectmapping.meta.Comment;
import org.sayandev.sayanvanish.lib.spongepowered.configurate.serialize.TypeSerializer;
import org.sayandev.sayanvanish.lib.spongepowered.configurate.serialize.TypeSerializerCollection;
import org.sayandev.sayanvanish.lib.stickynote.bukkit.nms.NMSUtils;
import org.sayandev.sayanvanish.lib.stickynote.bukkit.nms.PacketUtils;
import org.sayandev.sayanvanish.lib.stickynote.bukkit.utils.ServerVersion;

@RegisteredFeature
@ConfigSerializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0003J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\u0010\u001a\u00020\u00002\u000e\b\u0003\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/sayandev/sayanvanish/bukkit/feature/features/FeatureEffect;", "Lorg/sayandev/sayanvanish/bukkit/feature/ListenedFeature;", "effects", "", "Lorg/sayandev/sayanvanish/bukkit/feature/features/PotionEffectData;", "<init>", "(Ljava/util/List;)V", "getEffects", "()Ljava/util/List;", "onVanish", "", "event", "Lorg/sayandev/sayanvanish/bukkit/api/event/BukkitUserVanishEvent;", "onUnVanish", "Lorg/sayandev/sayanvanish/bukkit/api/event/BukkitUserUnVanishEvent;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "sayanvanish-bukkit"})
@SourceDebugExtension(value={"SMAP\nFeatureEffect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureEffect.kt\norg/sayandev/sayanvanish/bukkit/feature/features/FeatureEffect\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n774#2:113\n865#2,2:114\n1#3:116\n*S KotlinDebug\n*F\n+ 1 FeatureEffect.kt\norg/sayandev/sayanvanish/bukkit/feature/features/FeatureEffect\n*L\n78#1:113\n78#1:114,2\n*E\n"})
public final class FeatureEffect
extends ListenedFeature {
    @NotNull
    private final List<PotionEffectData> effects;

    public FeatureEffect(@Comment(value="\n    All effects will being sent using packets to prevent conflict with other plugins or desyncs.\n    List of effects to apply when a player vanishes\n    ") @NotNull List<PotionEffectData> effects) {
        Intrinsics.checkNotNullParameter(effects, (String)"effects");
        TypeSerializerCollection typeSerializerCollection = TypeSerializerCollection.builder().register(PotionEffectType.class, (TypeSerializer)new PotionEffectTypeSerializer()).build();
        Intrinsics.checkNotNullExpressionValue((Object)typeSerializerCollection, (String)"build(...)");
        super("effect", false, null, typeSerializerCollection, false, 22, null);
        this.effects = effects;
    }

    public /* synthetic */ FeatureEffect(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Object[] objectArray = new PotionEffectData[3];
            boolean bl = ServerVersion.supports((int)9);
            String string = PotionEffectType.NIGHT_VISION.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            objectArray[0] = new PotionEffectData(bl, false, string, Integer.MAX_VALUE, 0, false, false);
            String string2 = PotionEffectType.WATER_BREATHING.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            objectArray[1] = new PotionEffectData(false, false, string2, Integer.MAX_VALUE, 0, false, false);
            String string3 = PotionEffectType.FIRE_RESISTANCE.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            objectArray[2] = new PotionEffectData(false, false, string3, Integer.MAX_VALUE, 0, false, false);
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        this(list);
    }

    @NotNull
    public final List<PotionEffectData> getEffects() {
        return this.effects;
    }

    @EventHandler
    private final void onVanish(BukkitUserVanishEvent event) {
        BukkitUser user2 = event.getUser();
        if (!this.isActive(user2)) {
            return;
        }
        Player player = user2.player();
        if (player == null) {
            return;
        }
        Player player2 = player;
        for (PotionEffectData effect : this.effects) {
            if (effect.getUsePacket()) {
                Object[] objectArray = new Object[]{PacketUtils.getUpdateMobEffectPacket((Player)player2, (PotionEffect)effect.toPotionEffect())};
                NMSUtils.sendPacket((Player)player2, (Object[])objectArray);
                continue;
            }
            player2.addPotionEffect(effect.toPotionEffect());
        }
    }

    /*
     * WARNING - void declaration
     */
    @EventHandler
    private final void onUnVanish(BukkitUserUnVanishEvent event) {
        void $this$filterTo$iv$iv;
        BukkitUser user2 = event.getUser();
        if (!this.isActive(user2)) {
            return;
        }
        Player player = user2.player();
        if (player == null) {
            return;
        }
        Player player2 = player;
        Iterable $this$filter$iv = this.effects;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PotionEffectData it = (PotionEffectData)element$iv$iv;
            boolean bl = false;
            if (!(!it.getKeepAfterAppear())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (PotionEffectData effect : (List)destination$iv$iv) {
            Object v3;
            block6: {
                if (effect.getUsePacket()) {
                    Object[] objectArray = new Object[1];
                    PotionEffectType potionEffectType = PotionEffectType.getByName((String)effect.getType());
                    Intrinsics.checkNotNull((Object)potionEffectType);
                    objectArray[0] = PacketUtils.getRemoveMobEffectPacket((Player)player2, (PotionEffectType)potionEffectType);
                    NMSUtils.sendPacket((Player)player2, (Object[])objectArray);
                    continue;
                }
                Collection collection = player2.getActivePotionEffects();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getActivePotionEffects(...)");
                iterable = collection;
                for (Object t : iterable) {
                    PotionEffect it = (PotionEffect)t;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getType().getName(), (Object)effect.getType()) && it.getAmplifier() == effect.getAmplifier() && it.isAmbient() == effect.getAmbient() && it.hasParticles() == effect.getParticles())) continue;
                    v3 = t;
                    break block6;
                }
                v3 = null;
            }
            if (v3 == null) continue;
            PotionEffectType potionEffectType = PotionEffectType.getByName((String)effect.getType());
            Intrinsics.checkNotNull((Object)potionEffectType);
            player2.removePotionEffect(potionEffectType);
        }
    }

    @NotNull
    public final List<PotionEffectData> component1() {
        return this.effects;
    }

    @NotNull
    public final FeatureEffect copy(@Comment(value="\n    All effects will being sent using packets to prevent conflict with other plugins or desyncs.\n    List of effects to apply when a player vanishes\n    ") @NotNull List<PotionEffectData> effects) {
        Intrinsics.checkNotNullParameter(effects, (String)"effects");
        return new FeatureEffect(effects);
    }

    public static /* synthetic */ FeatureEffect copy$default(FeatureEffect featureEffect, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = featureEffect.effects;
        }
        return featureEffect.copy(list);
    }

    @NotNull
    public String toString() {
        return "FeatureEffect(effects=" + this.effects + ")";
    }

    public int hashCode() {
        return ((Object)this.effects).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FeatureEffect)) {
            return false;
        }
        FeatureEffect featureEffect = (FeatureEffect)((Object)other);
        return Intrinsics.areEqual(this.effects, featureEffect.effects);
    }

    public FeatureEffect() {
        this(null, 1, null);
    }
}

